/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.cytoscape.view;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.mit.broad.cytoscape.CytoscapeCyrest;
import edu.mit.broad.cytoscape.EnrichmentMapParameters;
import edu.mit.broad.cytoscape.view.CollapsiblePanel;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.xbench.core.api.Application;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.log4j.Logger;
import xapps.api.vtools.ParamSetFormForAFew;
import xtools.munge.CollapseDataset;

public class EnrichmentMapParameterPanel
extends JPanel {
    public static final String LAUNCH_MSG = "Please launch Cytoscape 3.3+ with the Enrichment Map plug-in before continuing.";
    private static final Logger klog = Logger.getLogger(EnrichmentMapParameterPanel.class);
    private DecimalFormat decFormat;
    private JFormattedTextField pvalueTextField;
    private JFormattedTextField qvalueTextField;
    private JFormattedTextField coeffecientTextField;
    private JFormattedTextField combinedConstantTextField;
    private JFormattedTextField GCTFileName1TextField;
    private JFormattedTextField GCTFileName2TextField;
    private JRadioButton overlap;
    private JRadioButton jaccard;
    private JRadioButton combined;
    private boolean similarityCutOffChanged = false;
    public static final ImageIcon similarityLogo = JarResources.getImageIcon("GSEA_similarityLogo.png");
    private JPanel similarityPanel;
    private JLabel combinedCutoff;
    private EnrichmentMapParameters params = new EnrichmentMapParameters("", "");

    public EnrichmentMapParameterPanel(String[] datasets) {
        this.setLayout(new BorderLayout());
        JPanel top_panel = new JPanel();
        JPanel dataset_panel = this.createDatasetPanel(datasets);
        JPanel param_panel = this.createParametersPanel();
        JPanel button_panel = this.createBottomPanel();
        StringBuffer colStr = EnrichmentMapParameterPanel._createColStr();
        if (datasets.length > 1) {
            top_panel.setLayout((LayoutManager)new FormLayout(colStr.toString(), "175dlu,4dlu,260dlu,4dlu"));
        } else {
            top_panel.setLayout((LayoutManager)new FormLayout(colStr.toString(), "100dlu,4dlu,260dlu,4dlu"));
        }
        CellConstraints cc = new CellConstraints();
        top_panel.add((Component)dataset_panel, cc.xywh(1, 1, 5, 1));
        top_panel.add((Component)param_panel, cc.xy(3, 3));
        this.add((Component)top_panel, "North");
        this.add((Component)button_panel, "South");
        this.GCTFileName1TextField.setFont(new Font("Dialog", 1, 10));
        this.GCTFileName1TextField.setText(this.params.getExpressionFilePath());
        this.GCTFileName1TextField.setToolTipText(this.params.getExpressionFilePath());
    }

    private JPanel createParametersPanel() {
        JPanel panel = new JPanel();
        CellConstraints CC = new CellConstraints();
        panel.setBorder(new CompoundBorder(new TitledBorder(new LineBorder(Color.black), "Enrichment Map Parameters", 2, 2, new Font("Dialog", 1, 12), Color.black), this.getBorder()));
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if ("border".equals(e.getPropertyName())) {
                    throw new RuntimeException();
                }
            }
        });
        panel.setLayout((LayoutManager)new FormLayout("4dlu, 4dlu, 65dlu, 4dlu, 30dlu, 90dlu, 4dlu, 30dlu, 4dlu, 4dlu,15dlu,80dlu,4dlu", "15dlu, 4dlu, 15dlu, 4dlu, 200dlu"));
        ((FormLayout)panel.getLayout()).setRowGroups((int[][])new int[][]{{1, 3}});
        JLabel emptyLabel = new JLabel(" ");
        JLabel pvalueCutOffLabel = new JLabel("P-value Cutoff");
        this.pvalueTextField = new JFormattedTextField(this.decFormat);
        this.pvalueTextField.setColumns(3);
        this.pvalueTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        String pvalueCutOffTip = "Sets the p-value cutoff \nonly genesets with a p-value less than \nthe cutoff will be included.";
        this.pvalueTextField.setToolTipText(pvalueCutOffTip);
        pvalueCutOffLabel.setToolTipText(pvalueCutOffTip);
        this.pvalueTextField.setText(Double.toString(this.params.getPvalue()));
        this.pvalueTextField.setValue(this.params.getPvalue());
        JPanel pvalueCutOffPanel = new JPanel();
        pvalueCutOffPanel.setLayout(new BorderLayout());
        pvalueCutOffPanel.setToolTipText(pvalueCutOffTip);
        panel.add((Component)pvalueCutOffLabel, CC.xy(3, 1));
        panel.add((Component)this.pvalueTextField, CC.xy(5, 1));
        panel.add((Component)emptyLabel, CC.xy(11, 1));
        JLabel qvalueCutOffLabel = new JLabel("FDR Q-value Cutoff");
        this.qvalueTextField = new JFormattedTextField(this.decFormat);
        this.qvalueTextField.setColumns(3);
        this.qvalueTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        String qvalueCutOffTip = "Sets the FDR q-value cutoff \nonly genesets with a FDR q-value less than \nthe cutoff will be included.";
        this.qvalueTextField.setToolTipText(qvalueCutOffTip);
        qvalueCutOffLabel.setToolTipText(qvalueCutOffTip);
        this.qvalueTextField.setText(Double.toString(this.params.getQvalue()));
        this.qvalueTextField.setValue(this.params.getQvalue());
        JPanel qvalueCutOffPanel = new JPanel();
        qvalueCutOffPanel.setLayout(new BorderLayout());
        qvalueCutOffPanel.setToolTipText(qvalueCutOffTip);
        panel.add((Component)qvalueCutOffLabel, CC.xy(3, 3));
        panel.add((Component)this.qvalueTextField, CC.xy(5, 3));
        panel.add((Component)emptyLabel, CC.xy(11, 3));
        JLabel similarityCutoff = new JLabel("Similarity Cutoff:");
        this.jaccard = new JRadioButton("Jaccard Coefficient");
        this.jaccard.setActionCommand("jaccard");
        this.jaccard.setSelected(true);
        this.jaccard.setToolTipText("Jaccard Coefficient = [size of (A intersect B)] / [size of (A union B)]");
        this.overlap = new JRadioButton("Overlap Coefficient");
        this.overlap.setActionCommand("overlap");
        this.overlap.setToolTipText("Overlap Coefficient = [size of (A intersect B)] / [size of (minimum( A , B))]");
        this.combined = new JRadioButton("Jaccard+Overlap Combined");
        this.combined.setActionCommand("combined");
        this.combined.setToolTipText("Combined Constant = k; Combined Coefficient = (k * Overlap) + ((1-k) * Jaccard)");
        if (this.params.getSimilarityMetric().equalsIgnoreCase("JACCARD")) {
            this.jaccard.setSelected(true);
            this.overlap.setSelected(false);
            this.combined.setSelected(false);
        } else if (this.params.getSimilarityMetric().equalsIgnoreCase("OVERLAP")) {
            this.jaccard.setSelected(false);
            this.overlap.setSelected(true);
            this.combined.setSelected(false);
        } else if (this.params.getSimilarityMetric().equalsIgnoreCase("COMBINED")) {
            this.jaccard.setSelected(false);
            this.overlap.setSelected(false);
            this.combined.setSelected(true);
        }
        ButtonGroup jaccardOrOverlap = new ButtonGroup();
        jaccardOrOverlap.add(this.jaccard);
        jaccardOrOverlap.add(this.overlap);
        jaccardOrOverlap.add(this.combined);
        this.jaccard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapParameterPanel.this.selectJaccardOrOverlapActionPerformed(evt);
            }
        });
        this.overlap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapParameterPanel.this.selectJaccardOrOverlapActionPerformed(evt);
            }
        });
        this.combined.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapParameterPanel.this.selectJaccardOrOverlapActionPerformed(evt);
            }
        });
        JLabel coeffecientCutOffLabel = new JLabel("Cutoff");
        this.coeffecientTextField = new JFormattedTextField(this.decFormat);
        this.coeffecientTextField.setColumns(3);
        this.coeffecientTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        String coeffecientCutOffTip = "Sets the Jaccard or Overlap coefficient cutoff \nonly edges with a Jaccard or Overlap coefficient less than \nthe cutoff will be added.";
        this.coeffecientTextField.setToolTipText(coeffecientCutOffTip);
        this.coeffecientTextField.setValue(this.params.getSimilarityCutOff());
        this.similarityCutOffChanged = false;
        this.combinedCutoff = new JLabel("Combined Constant");
        this.combinedConstantTextField = new JFormattedTextField(this.decFormat);
        this.combinedConstantTextField.setColumns(3);
        this.combinedConstantTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        this.combinedConstantTextField.setValue(0.5);
        this.combinedCutoff.setForeground(Color.GRAY);
        CollapsiblePanel collapsible_similarityPanel = new CollapsiblePanel("Advanced Options");
        JPanel similarityPanel = collapsible_similarityPanel.getContentPane();
        CellConstraints CC_sp = new CellConstraints();
        similarityPanel.setLayout((LayoutManager)new FormLayout("1dlu, 1dlu, 30dlu,35dlu, 1dlu, 30dlu, 90dlu, 1dlu, 30dlu,120dlu", "15dlu, 15dlu,15dlu,15dlu,15dlu,5dlu,100dlu"));
        similarityPanel.add((Component)similarityCutoff, CC_sp.xywh(3, 1, 5, 1));
        similarityPanel.add((Component)this.jaccard, CC_sp.xywh(4, 2, 4, 1));
        similarityPanel.add((Component)this.coeffecientTextField, CC_sp.xywh(9, 2, 1, 3));
        similarityPanel.add((Component)this.overlap, CC_sp.xywh(4, 3, 4, 1));
        similarityPanel.add((Component)this.combined, CC_sp.xywh(4, 4, 4, 1));
        similarityPanel.add((Component)this.combinedCutoff, CC_sp.xy(7, 5, CellConstraints.CENTER, CellConstraints.DEFAULT));
        similarityPanel.add((Component)this.combinedConstantTextField, CC_sp.xy(9, 5));
        this.combinedConstantTextField.setEnabled(false);
        similarityPanel.add((Component)new JLabel("", similarityLogo, 0), CC_sp.xywh(2, 7, 9, 1));
        panel.add((Component)collapsible_similarityPanel, CC.xywh(3, 5, 11, 1));
        collapsible_similarityPanel.setCollapsed(false);
        collapsible_similarityPanel.setCollapsed(true);
        return panel;
    }

    private void createExpression1FilePanel(PanelBuilder builder, CellConstraints cc, int rowcnt) {
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(1000, 60));
        panel.setLayout(new BorderLayout());
        JLabel GCTLabel = new JLabel("*Expression (Dataset 1):");
        GCTLabel.setToolTipText("File with gene expression values.\nFormat: gene <tab> description <tab> expression value <tab> ...");
        JButton selectGCTFileButton = new JButton();
        this.GCTFileName1TextField = new JFormattedTextField();
        this.GCTFileName1TextField.setColumns(15);
        this.GCTFileName1TextField.setText(this.params.getExpressionFilePath());
        selectGCTFileButton.setText("...");
        selectGCTFileButton.setMargin(new Insets(0, 0, 0, 0));
        selectGCTFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapParameterPanel.this.selectGCTFileButtonActionPerformed(evt);
            }
        });
        JPanel GCTPanel = new JPanel();
        GCTPanel.setLayout(new BorderLayout());
        GCTPanel.add((Component)this.GCTFileName1TextField, "Center");
        GCTPanel.add((Component)selectGCTFileButton, "East");
        builder.add((Component)GCTLabel, cc.xy(1, rowcnt));
        builder.add((Component)GCTPanel, cc.xy(3, rowcnt));
    }

    private void createExpression2FilePanel(PanelBuilder builder, CellConstraints cc, int rowcnt) {
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(1000, 60));
        panel.setLayout(new BorderLayout());
        JLabel GCTLabel = new JLabel("*Expression (Dataset 2):");
        GCTLabel.setToolTipText("File with gene expression values.\nFormat: gene <tab> description <tab> expression value <tab> ...");
        JButton selectGCTFile2Button = new JButton();
        this.GCTFileName2TextField = new JFormattedTextField();
        this.GCTFileName2TextField.setColumns(15);
        this.GCTFileName2TextField.setText(this.params.getExpression2FilePath());
        selectGCTFile2Button.setText("...");
        selectGCTFile2Button.setMargin(new Insets(0, 0, 0, 0));
        selectGCTFile2Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapParameterPanel.this.selectGCTFile2ButtonActionPerformed(evt);
            }
        });
        JPanel GCT2Panel = new JPanel();
        GCT2Panel.setLayout(new BorderLayout());
        GCT2Panel.add((Component)this.GCTFileName2TextField, "Center");
        GCT2Panel.add((Component)selectGCTFile2Button, "East");
        builder.add((Component)GCTLabel, cc.xy(1, rowcnt));
        builder.add((Component)GCT2Panel, cc.xy(3, rowcnt));
    }

    private JPanel createExpression1FilePanel() {
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(1000, 60));
        panel.setLayout(new BorderLayout());
        JLabel GCTLabel = new JLabel("*Expression (Dataset 1):");
        GCTLabel.setToolTipText("File with gene expression values.\nFormat: gene <tab> description <tab> expression value <tab> ...");
        JButton selectGCTFileButton = new JButton();
        this.GCTFileName1TextField = new JFormattedTextField();
        this.GCTFileName1TextField.setColumns(15);
        this.GCTFileName1TextField.setText(this.params.getExpressionFilePath());
        selectGCTFileButton.setText("...");
        selectGCTFileButton.setMargin(new Insets(0, 0, 0, 0));
        selectGCTFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapParameterPanel.this.selectGCTFileButtonActionPerformed(evt);
            }
        });
        JPanel GCTPanel = new JPanel();
        GCTPanel.setLayout(new BorderLayout());
        GCTPanel.add((Component)GCTLabel, "West");
        GCTPanel.add((Component)this.GCTFileName1TextField, "Center");
        GCTPanel.add((Component)selectGCTFileButton, "East");
        panel.add((Component)GCTPanel, "North");
        panel.add((Component)this.createInstruction(), "Center");
        this.add((Component)this.createBottomPanel(), "South");
        return panel;
    }

    private JTextArea createInstruction() {
        String text = "*If you are using GSEAPreranked and you would like to see the expression values in the heat map instead of the ranks change this default setting.";
        JTextArea instruction = new JTextArea(text);
        instruction.setRows(2);
        instruction.setEditable(false);
        instruction.setLineWrap(true);
        instruction.setWrapStyleWord(true);
        instruction.setPreferredSize(new Dimension(600, 20));
        return instruction;
    }

    private void selectJaccardOrOverlapActionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equalsIgnoreCase("jaccard")) {
            this.combinedCutoff.setForeground(Color.GRAY);
            this.combinedConstantTextField.setEnabled(false);
            this.params.setSimilarityMetric("JACCARD");
            if (!this.similarityCutOffChanged) {
                this.params.setSimilarityCutOff(this.params.getDefaultJaccardCutOff());
                this.coeffecientTextField.setValue(this.params.getSimilarityCutOff());
                this.similarityCutOffChanged = false;
            }
        } else if (evt.getActionCommand().equalsIgnoreCase("overlap")) {
            this.combinedCutoff.setForeground(Color.GRAY);
            this.combinedConstantTextField.setEnabled(false);
            this.params.setSimilarityMetric("OVERLAP");
            if (!this.similarityCutOffChanged) {
                this.params.setSimilarityCutOff(this.params.getDefaultOverlapCutOff());
                this.coeffecientTextField.setValue(this.params.getSimilarityCutOff());
                this.similarityCutOffChanged = false;
            }
        } else if (evt.getActionCommand().equalsIgnoreCase("combined")) {
            this.combinedCutoff.setForeground(Color.BLACK);
            this.combinedConstantTextField.setEnabled(true);
            this.params.setSimilarityMetric("COMBINED");
            if (!this.similarityCutOffChanged) {
                this.params.setSimilarityCutOff(this.params.getDefaultOverlapCutOff() * this.params.getCombinedConstant() + (1.0 - this.params.getCombinedConstant()) * this.params.getDefaultJaccardCutOff());
                this.coeffecientTextField.setValue(this.params.getSimilarityCutOff());
                this.similarityCutOffChanged = false;
            }
        } else {
            JOptionPane.showMessageDialog(this, "Invalid Jaccard Radio Button action command");
        }
        this.similarityPanel.revalidate();
    }

    private void selectGCTFileButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(this.params.getEdbdir());
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Expression File", "gct", "rnk", "txt");
        File file = null;
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            file = chooser.getSelectedFile();
        }
        if (file != null) {
            this.params.setExpressionFilePath(file.getAbsolutePath());
            this.GCTFileName1TextField.setText(file.getAbsolutePath());
            this.GCTFileName1TextField.setToolTipText(file.getAbsolutePath());
        }
    }

    private void selectGCTFile2ButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(this.params.getEdbdir());
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Expression File", "gct", "rnk", "txt");
        File file = null;
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            file = chooser.getSelectedFile();
        }
        if (file != null) {
            this.params.setExpression2FilePath(file.getAbsolutePath());
            this.GCTFileName2TextField.setText(file.getAbsolutePath());
            this.GCTFileName2TextField.setToolTipText(file.getAbsolutePath());
        }
    }

    private JPanel createBottomPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        JButton importButton = new JButton();
        importButton.setText("Build Enrichment Map");
        importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnrichmentMapParameterPanel.this.BuildActionPerformed(evt);
            }
        });
        importButton.setEnabled(true);
        panel.add(importButton);
        return panel;
    }

    private void BuildActionPerformed(ActionEvent evt) {
        CytoscapeCyrest cyto = new CytoscapeCyrest(this.params);
        try {
            if (!cyto.CytoscapeRestActive()) {
                klog.info((Object)LAUNCH_MSG);
                Application.getWindowManager().showConfirm(LAUNCH_MSG);
            }
            if (cyto.CytoscapeRestActive() && cyto.CytoscapeRestCommandEM() && cyto.createEM_get()) {
                Application.getWindowManager().showMessage("An Enrichment map was successfully loaded and created in cytoscape.  Please navigate to cytoscape to view results");
            }
        }
        catch (IOException e) {
            klog.info((Object)("Unable to communicate with cytoscape:" + e.getMessage()));
            klog.info((Object)LAUNCH_MSG);
            Application.getWindowManager().showConfirm(LAUNCH_MSG);
        }
        catch (URISyntaxException e) {
            klog.info((Object)("Issue with cytoscape rest command:" + e.getMessage()));
        }
    }

    private JPanel createDatasetPanel(String[] datasets) {
        Arrays.sort(datasets);
        int num_rows = datasets.length * 5;
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        StringBuffer colStr = EnrichmentMapParameterPanel._createColStr();
        StringBuffer rowStr = EnrichmentMapParameterPanel._createRowStr(num_rows + 2);
        PanelBuilder builder = ParamSetFormForAFew.createPanelBuilder(colStr, rowStr);
        CellConstraints cc = new CellConstraints();
        JLabel ds1Label = new JLabel("Dataset 1:");
        JComboBox<String> ds1combobox = new JComboBox<String>(datasets);
        ds1combobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JComboBox cb = (JComboBox)evt.getSource();
                String edb = (String)cb.getSelectedItem();
                EnrichmentMapParameterPanel.this.params.setEdbdir(edb);
                String expFile = EnrichmentMapParameterPanel.this.getExpressionFile(edb);
                if (expFile != null && !expFile.equalsIgnoreCase("")) {
                    EnrichmentMapParameterPanel.this.params.setExpressionFilePath(expFile);
                    if (EnrichmentMapParameterPanel.this.GCTFileName1TextField != null) {
                        EnrichmentMapParameterPanel.this.GCTFileName1TextField.setText(expFile);
                    }
                }
            }
        });
        ds1combobox.setSelectedIndex(0);
        int rowcnt = 3;
        builder.addSeparator("Dataset 1", cc.xyw(1, 1, 4));
        builder.add((Component)ds1Label, cc.xy(1, rowcnt));
        builder.add(ds1combobox, cc.xy(3, rowcnt));
        this.createExpression1FilePanel(builder, cc, rowcnt += 2);
        rowcnt += 2;
        if (datasets.length > 1) {
            JLabel ds2Label = new JLabel("Dataset 2:");
            JComboBox<String> ds2combobox = new JComboBox<String>(datasets);
            ds2combobox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JComboBox cb = (JComboBox)evt.getSource();
                    String edb = (String)cb.getSelectedItem();
                    EnrichmentMapParameterPanel.this.params.setEdbdir2(edb);
                    String expFile = EnrichmentMapParameterPanel.this.getExpressionFile(edb);
                    if (expFile != null && !expFile.equalsIgnoreCase("")) {
                        EnrichmentMapParameterPanel.this.params.setExpression2FilePath(expFile);
                        if (EnrichmentMapParameterPanel.this.GCTFileName2TextField != null) {
                            EnrichmentMapParameterPanel.this.GCTFileName2TextField.setText(expFile);
                        }
                    }
                }
            });
            ds2combobox.setSelectedIndex(1);
            builder.addSeparator("Dataset 2", cc.xyw(1, rowcnt, 4));
            builder.add((Component)ds2Label, cc.xy(1, rowcnt += 2));
            builder.add(ds2combobox, cc.xy(3, rowcnt));
            this.createExpression2FilePanel(builder, cc, rowcnt += 2);
            rowcnt += 2;
        }
        builder.add((Component)this.createInstruction(), cc.xy(3, rowcnt));
        return builder.getPanel();
    }

    private String getExpressionFile(String edb) {
        File[] files;
        File parentDir;
        Object expressionFile = null;
        File edbdir = new File(edb);
        if (!edbdir.getName().equalsIgnoreCase("edb")) {
            edbdir = new File(edb + System.getProperty("file.separator") + "edb");
        }
        if (edbdir.exists() && edbdir.isDirectory() && (parentDir = edbdir.getParentFile()).exists() && parentDir.isDirectory() && (files = parentDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".rpt");
            }
        })).length == 1) {
            String rptFile = files[0].getAbsolutePath();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(rptFile)));
                HashMap<Object, String> rpt = new HashMap<Object, String>();
                while ((line = reader.readLine()) != null) {
                    String[] tokens = line.split("\t");
                    if (tokens.length == 2) {
                        rpt.put(tokens[0], tokens[1]);
                        continue;
                    }
                    if (tokens.length != 3) continue;
                    rpt.put(tokens[0] + " " + tokens[1], tokens[2]);
                }
                String collapse = "";
                if (rpt.containsKey("param collapse")) {
                    collapse = (String)rpt.get("param collapse");
                }
                if (rpt.containsKey("param rnk")) {
                    expressionFile = (String)rpt.get("param rnk");
                } else if (rpt.containsKey("param res")) {
                    String res = (String)rpt.get("param res");
                    if (!new File(res).exists()) {
                        Application.getWindowManager().showConfirm("Unable to find expression file: " + res);
                    }
                    if (collapse.equalsIgnoreCase("false")) {
                        expressionFile = res;
                    } else {
                        Properties props = new Properties();
                        props.put("res", res);
                        String rpt_label = rpt.containsKey("param rpt_label") ? (String)rpt.get("param rpt_label") : "";
                        props.put("rpt_label", rpt_label);
                        String mode = rpt.containsKey("param mode") ? (String)rpt.get("param mode") : "";
                        props.put("mode", mode);
                        String chip = rpt.containsKey("param chip") ? (String)rpt.get("param chip") : "";
                        props.put("chip", chip);
                        String include = rpt.containsKey("param include_only_symbols") ? (String)rpt.get("param include_only_symbols") : "";
                        props.put("include_only_symbols", include);
                        String out = rpt.containsKey("param out") ? (String)rpt.get("param out") : "";
                        props.put("out", out);
                        props.put("gui", "false");
                        if (!(rpt_label.equalsIgnoreCase("") || mode.equalsIgnoreCase("") || chip.equalsIgnoreCase("") || include.equalsIgnoreCase("") || out.equalsIgnoreCase(""))) {
                            CollapseDataset tool = new CollapseDataset(props);
                            try {
                                tool.execute();
                                File report_dir = tool.getReport().getReportDir();
                                File res_file = new File(res);
                                String tempFile = res_file.getName();
                                String simplename = "";
                                simplename = tempFile.replace(".gct", "_collapsed_to_symbols.gct");
                                expressionFile = report_dir + System.getProperty("file.separator") + simplename;
                            }
                            catch (Throwable t) {
                                System.out.println(t.getMessage());
                            }
                        } else if (edbdir.exists() && edbdir.isDirectory()) {
                            File[] edbfiles = edbdir.listFiles(new FilenameFilter(){

                                @Override
                                public boolean accept(File dir, String name) {
                                    return name.toLowerCase().endsWith(".rnk");
                                }
                            });
                            if (files.length == 1) {
                                expressionFile = files[0].getAbsolutePath();
                            }
                        } else {
                            expressionFile = "Unable to get expresion File";
                        }
                    }
                } else {
                    expressionFile = "Unable to get expresion File";
                }
            }
            catch (IOException e) {
                System.out.println("Unable to open rpt file:" + rptFile);
            }
        }
        return expressionFile;
    }

    private static StringBuffer _createColStr() {
        return new StringBuffer("120dlu,      4dlu,        380dlu,   4dlu,  10dlu");
    }

    private static StringBuffer _createRowStr(int num_params) {
        StringBuffer rowStr = new StringBuffer();
        rowStr.append("pref, 10dlu,");
        for (int i = 0; i < num_params + 1; ++i) {
            rowStr.append("pref, 5dlu");
            if (num_params == i - 1) continue;
            rowStr.append(",");
        }
        return rowStr;
    }

    private class FormattedTextFieldAction
    implements PropertyChangeListener {
        private FormattedTextFieldAction() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            JFormattedTextField source = (JFormattedTextField)e.getSource();
            Object message = "The value you have entered is invalid.\n";
            boolean invalid = false;
            if (source == EnrichmentMapParameterPanel.this.pvalueTextField) {
                Number value = (Number)EnrichmentMapParameterPanel.this.pvalueTextField.getValue();
                if (value != null && value.doubleValue() > 0.0 && value.doubleValue() <= 1.0) {
                    EnrichmentMapParameterPanel.this.params.setPvalue(value.doubleValue());
                } else {
                    source.setValue(EnrichmentMapParameterPanel.this.params.getPvalue());
                    message = (String)message + "The pvalue cutoff must be greater than or equal 0 and less than or equal to 1.";
                    invalid = true;
                }
            } else if (source == EnrichmentMapParameterPanel.this.qvalueTextField) {
                Number value = (Number)EnrichmentMapParameterPanel.this.qvalueTextField.getValue();
                if (value != null && value.doubleValue() >= 0.0 && value.doubleValue() <= 100.0) {
                    EnrichmentMapParameterPanel.this.params.setQvalue(value.doubleValue());
                } else {
                    source.setValue(EnrichmentMapParameterPanel.this.params.getQvalue());
                    message = (String)message + "The FDR q-value cutoff must be between 0 and 100.";
                    invalid = true;
                }
            } else if (source == EnrichmentMapParameterPanel.this.coeffecientTextField) {
                Number value = (Number)EnrichmentMapParameterPanel.this.coeffecientTextField.getValue();
                if (value != null && value.doubleValue() >= 0.0 && value.doubleValue() <= 1.0) {
                    EnrichmentMapParameterPanel.this.params.setSimilarityCutOff(value.doubleValue());
                    EnrichmentMapParameterPanel.this.similarityCutOffChanged = true;
                } else {
                    source.setValue(EnrichmentMapParameterPanel.this.params.getSimilarityCutOff());
                    message = (String)message + "The Overlap/Jaccard Coefficient cutoff must be between 0 and 1.";
                    invalid = true;
                }
            } else if (source == EnrichmentMapParameterPanel.this.combinedConstantTextField) {
                Number value = (Number)EnrichmentMapParameterPanel.this.combinedConstantTextField.getValue();
                if (value != null && value.doubleValue() >= 0.0 && value.doubleValue() <= 1.0) {
                    EnrichmentMapParameterPanel.this.params.setCombinedConstant(value.doubleValue());
                    if (!EnrichmentMapParameterPanel.this.similarityCutOffChanged && EnrichmentMapParameterPanel.this.params.getSimilarityMetric().equalsIgnoreCase("COMBINED")) {
                        EnrichmentMapParameterPanel.this.params.setSimilarityCutOff(EnrichmentMapParameterPanel.this.params.getDefaultOverlapCutOff() * value.doubleValue() + (1.0 - value.doubleValue()) * EnrichmentMapParameterPanel.this.params.getDefaultJaccardCutOff());
                    }
                } else {
                    source.setValue(0.5);
                    message = (String)message + "The combined Overlap/Jaccard Coefficient constant must be between 0 and 1.";
                    invalid = true;
                }
            }
            if (invalid) {
                // empty if block
            }
        }
    }
}

