/*
 * Decompiled with CFR 0.152.
 */
package xtools.gsea;

import edu.mit.broad.genome.alg.DatasetGenerators;
import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.alg.gsea.GeneSetCohortGenerator;
import edu.mit.broad.genome.alg.gsea.KSTests;
import edu.mit.broad.genome.math.LabelledVectorProcessors;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.RandomSeedGenerator;
import edu.mit.broad.genome.math.RandomSeedGenerators;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateMode;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.objects.strucs.CollapsedDetails;
import edu.mit.broad.genome.objects.strucs.DatasetTemplate;
import edu.mit.broad.genome.objects.strucs.TemplateRandomizerType;
import edu.mit.broad.genome.parsers.EdbFolderParser;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.reports.EnrichmentReports;
import edu.mit.broad.genome.reports.pages.HtmlPage;
import edu.mit.broad.genome.reports.pages.HtmlReportIndexPage;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.xbench.prefs.XPreferencesFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import xtools.api.param.BadParamException;
import xtools.api.param.BooleanParam;
import xtools.api.param.ChipOptParam;
import xtools.api.param.DatasetReqdParam;
import xtools.api.param.FeatureSpaceReqdParam;
import xtools.api.param.IntegerParam;
import xtools.api.param.MetricParam;
import xtools.api.param.ModeReqdParam;
import xtools.api.param.OrderParam;
import xtools.api.param.PermuteTypeChooserParam;
import xtools.api.param.SortParam;
import xtools.api.param.TemplateRandomizerTypeParam;
import xtools.api.param.TemplateSingleChooserParam;
import xtools.gsea.AbstractGseaTool;

public abstract class AbstractGsea2Tool
extends AbstractGseaTool {
    protected final DatasetReqdParam fDatasetParam = new DatasetReqdParam();
    protected final TemplateSingleChooserParam fTemplateParam = new TemplateSingleChooserParam("cls", "Phenotype labels", TemplateMode.CATEGORICAL_2_CLASS_AND_NUMERIC, true);
    protected final MetricParam fMetricParam = new MetricParam(AbstractGsea2Tool.createMetricsForGsea(), false);
    protected final OrderParam fOrderParam = new OrderParam(false);
    protected final SortParam fSortParam = new SortParam(false);
    protected final PermuteTypeChooserParam fPermuteTypeParamType = PermuteTypeChooserParam.createTemplateOrGeneSet(true);
    protected final BooleanParam fMedianParam = new BooleanParam("median", "Median for class  metrics", "Use the median of each class instead of the mean for the class seperation metrics", XPreferencesFactory.kMedian.getBoolean(), false);
    protected final IntegerParam fNumMarkersParam = new IntegerParam("num", "Number of markers", "Number of markers", 100, false);
    protected final BooleanParam fSaveRndRankedListsParam = new BooleanParam("save_rnd_lists", "Save random ranked lists", "Save random ranked lists (might be very large)", false, false);
    protected final TemplateRandomizerTypeParam fRndTypeParam = new TemplateRandomizerTypeParam(TemplateRandomizerType.NO_BALANCE, new TemplateRandomizerType[]{TemplateRandomizerType.NO_BALANCE, TemplateRandomizerType.EQUALIZE_AND_BALANCE}, true);
    protected ChipOptParam fChipParam = new ChipOptParam(false);
    protected final FeatureSpaceReqdParam fFeatureSpaceParam = new FeatureSpaceReqdParam();
    protected final ModeReqdParam fCollapseModeParam = new ModeReqdParam("mode", "Collapsing mode for probe sets => 1 gene", "Collapsing mode for probe sets => 1 gene", new String[]{"Max_probe", "Median_of_probes"});
    protected final BooleanParam fIncludeOnlySymbols = new BooleanParam("include_only_symbols", "Omit features with no symbol match", "If there is no known gene symbol match for a probe set omit if from the collapsed dataset", true, false);

    protected AbstractGsea2Tool() {
    }

    @Override
    protected void doAdditionalParams() {
        this.fParamSet.addParam(this.fDatasetParam);
        this.fParamSet.addParamPseudoReqd(this.fTemplateParam);
        this.fParamSet.addParamBasic(this.fMetricParam);
        this.fParamSet.addParamBasic(this.fOrderParam);
        this.fParamSet.addParamBasic(this.fSortParam);
        this.fParamSet.addParamPseudoReqd(this.fPermuteTypeParamType);
        this.fParamSet.addParamAdv(this.fMedianParam);
        this.fParamSet.addParamAdv(this.fNumMarkersParam);
        this.fParamSet.addParamAdv(this.fSaveRndRankedListsParam);
        this.fParamSet.addParamAdv(this.fRndTypeParam);
        this.fParamSet.addParamPseudoReqd(this.fChipParam);
        this.fParamSet.addParamPseudoReqd(this.fFeatureSpaceParam);
        this.fParamSet.addParamAdv(this.fIncludeOnlySymbols);
        this.fParamSet.addParamAdv(this.fCollapseModeParam);
    }

    protected EnrichmentDb execute_one(CollapsedDetails.Data fullCd, Template template, GeneSet[] gsets, List store_rnd_ranked_lists_here_opt) throws Exception {
        int nperms = this.fNumPermParam.getIValue();
        Metric metric = this.fMetricParam.getMetric();
        SortMode sort = this.fSortParam.getMode();
        Order order = this.fOrderParam.getOrder();
        LabelledVectorProcessors.None lvp = new LabelledVectorProcessors.None();
        RandomSeedGenerator rst = this.fRndSeedTypeParam.createSeed();
        Map<String, Boolean> mps = this.getMetricParams(this.fMedianParam);
        GeneSetCohortGenerator gcohgen = this.fGcohGenReqdParam.createGeneSetCohortGenerator(false);
        DatasetTemplate dt = new DatasetGenerators().extract(fullCd.getDataset(), template);
        this.log.debug((Object)(">>>>> Using samples: " + dt.getDataset().getColumnNames()));
        KSTests tests = new KSTests(this.getOutputStream());
        if (rst instanceof RandomSeedGenerators.Timestamp) {
            this.fReport.addComment("Timestamp used as random seed: " + ((RandomSeedGenerators.Timestamp)rst).getTimestamp());
        }
        return tests.executeGsea(dt, gsets, nperms, metric, sort, order, lvp, rst, this.fRndTypeParam.getRandomizerType(), mps, gcohgen, this.fPermuteTypeParamType.permuteTemplate(), this.fNumMarkersParam.getIValue(), store_rnd_ranked_lists_here_opt);
    }

    protected void execute_one_with_reporting(CollapsedDetails.Data fullCd, Template template, GeneSet[] gsets, HtmlReportIndexPage reportIndexPage, boolean makeSubDir, GeneSet[] origGeneSets, int showDetailsForTopXSets, boolean makeZippedReport, boolean makeGeneSetReports, boolean createSvgs, boolean createGcts) throws Exception {
        ArrayList store_rnd_ranked_lists_here_opt = null;
        if (this.fSaveRndRankedListsParam.isTrue()) {
            store_rnd_ranked_lists_here_opt = new ArrayList();
        }
        EnrichmentDb edb = this.execute_one(fullCd, template, gsets, store_rnd_ranked_lists_here_opt);
        Metric metric = this.fMetricParam.getMetric();
        int minSize = this.fGeneSetMinSizeParam.getIValue();
        int maxSize = this.fGeneSetMaxSizeParam.getIValue();
        DatasetTemplate dt = new DatasetGenerators().extract(fullCd.getDataset(), template);
        EnrichmentReports.Ret ret = EnrichmentReports.createGseaLikeReport(edb, this.getOutputStream(), (CollapsedDetails)fullCd, (HtmlPage)reportIndexPage, makeSubDir, this.fReport, showDetailsForTopXSets, minSize, maxSize, makeGeneSetReports, makeZippedReport, createSvgs, createGcts, origGeneSets, metric.getName(), this.fNormModeParam.getNormModeName());
        if (store_rnd_ranked_lists_here_opt != null && !store_rnd_ranked_lists_here_opt.isEmpty()) {
            File dir = this.fReport.createSubDir("random_ranked_lists");
            for (int r = 0; r < store_rnd_ranked_lists_here_opt.size(); ++r) {
                RankedList rl = (RankedList)store_rnd_ranked_lists_here_opt.get(r);
                String name = r + "_" + rl.getName();
                if (!StringUtils.endsWith((CharSequence)name, (CharSequence)".rnk")) {
                    name = name + ".rnk";
                }
                File file = new File(dir, name);
                ParserFactory.save(rl, file, false);
            }
        }
        if (this.fPermuteTypeParamType.permuteTemplate() && dt.getTemplate().isCategorical()) {
            if (dt.getTemplate().getClass(0).getSize() < 7) {
                this.fReport.addComment("Warning: Phenotype permutation was performed but the number of samples in class A is < 7, phenotype: " + dt.getTemplateName());
            }
            if (dt.getTemplate().getClass(1).getSize() < 7) {
                this.fReport.addComment("Warning: Phenotype permutation was performed but the number of samples in class B is < 7, phenotype: " + dt.getTemplateName());
            }
            if (dt.getTemplate().getNumItems() < 14) {
                this.fReport.addComment("With small datasets, there might not be enough random permutations of sample labels to generate a sufficient null distribution. In such cases, gene_set randomization might be a better choice.");
            }
        }
        new EdbFolderParser().export((PersistentObject)ret.edb, ret.savedInDir);
    }

    protected CollapsedDetails.Data getDataset(Dataset origDs) throws Exception {
        CollapsedDetails.Data cd = new CollapsedDetails.Data();
        cd.orig = origDs;
        if (this.fFeatureSpaceParam.isSymbols()) {
            if (!this.fChipParam.isSpecified()) {
                throw new BadParamException("Chip parameter must be specified as you asked to analyze in the space of gene symbols. Chip is used to collapse probe ids into symbols", 1002);
            }
            Chip chip = this.fChipParam.getChip();
            Dataset collapsed = new DatasetGenerators().collapse(origDs, chip, this.fIncludeOnlySymbols.isTrue(), this.fCollapseModeParam.getStringIndexChoosen());
            this.log.info((Object)("Collapsing dataset was done. Original: " + origDs.getQuickInfo() + " collapsed: " + collapsed.getQuickInfo()));
            cd.chip = chip;
            cd.wasCollapsed = true;
            cd.collapsed = collapsed;
            if (cd.getNumRow_orig() != 0 && cd.getNumRow_collapsed() == 0) {
                throw new BadParamException("The collapsed dataset was empty when used with chip:" + cd.getChipName(), 1005);
            }
        } else {
            cd.wasCollapsed = false;
            cd.collapsed = origDs;
            this.log.info((Object)"No dataset collapsing was done .. using original as is");
        }
        return cd;
    }

    public Map<String, Boolean> getMetricParams(BooleanParam medianParam) {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("USE_MEDIAN", XPreferencesFactory.kMedian.getBooleanO());
        params.put("FIX_LOW", XPreferencesFactory.kFixLowVar.getBooleanO());
        params.put("USE_BIASED", XPreferencesFactory.kBiasedVar.getBooleanO());
        params.put("USE_MEDIAN", (Boolean)medianParam.getValue());
        return Collections.unmodifiableMap(params);
    }
}

