/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jdbc.autoclose;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.ujmp.jdbc.autoclose.AutoCloseConnection;
import org.ujmp.jdbc.util.SQLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoOpenCloseConnection
implements Connection {
    private final String url;
    private final Properties properties;
    private final int maxIdleTime;
    private final int checkInterval;
    private Connection connection = null;

    public AutoOpenCloseConnection(String url, String username, String password) {
        this(url, username, password, 3600000);
    }

    public AutoOpenCloseConnection(String url, String username, String password, int maxIdleTime) {
        this(url, SQLUtil.createProperties(url, username, password), maxIdleTime, 1000);
    }

    public AutoOpenCloseConnection(String url, Properties properties, int maxIdleTime, int checkInterval) {
        this.url = url;
        this.maxIdleTime = maxIdleTime;
        this.checkInterval = checkInterval;
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)properties);
    }

    private synchronized Connection getConnection() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            SQLUtil.loadDriver(this.url);
            Connection c = DriverManager.getConnection(this.url, this.properties);
            this.connection = new AutoCloseConnection(c, this.maxIdleTime, this.checkInterval);
            if (SQLUtil.getSQLDialect(this.url) == SQLUtil.SQLDialect.MYSQL) {
                Statement statement = this.connection.createStatement();
                statement.execute("SET NAMES utf8");
                statement.close();
            } else if (SQLUtil.getSQLDialect(this.url) == SQLUtil.SQLDialect.SQLITE) {
                Statement statement = this.connection.createStatement();
                statement.execute("PRAGMA synchronous = Full");
                statement.close();
            }
        }
        return this.connection;
    }

    @Override
    public final synchronized <T> T unwrap(Class<T> iface) throws SQLException {
        return this.getConnection().unwrap(iface);
    }

    @Override
    public final synchronized boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getConnection().isWrapperFor(iface);
    }

    @Override
    public final synchronized Statement createStatement() throws SQLException {
        return this.getConnection().createStatement();
    }

    @Override
    public final synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.getConnection().prepareStatement(sql);
    }

    @Override
    public final synchronized CallableStatement prepareCall(String sql) throws SQLException {
        return this.getConnection().prepareCall(sql);
    }

    @Override
    public final synchronized String nativeSQL(String sql) throws SQLException {
        return this.getConnection().nativeSQL(sql);
    }

    @Override
    public final synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        this.getConnection().setAutoCommit(autoCommit);
    }

    @Override
    public final synchronized boolean getAutoCommit() throws SQLException {
        return this.getConnection().getAutoCommit();
    }

    @Override
    public final synchronized void commit() throws SQLException {
        this.getConnection().commit();
    }

    @Override
    public final synchronized void rollback() throws SQLException {
        this.getConnection().rollback();
    }

    @Override
    public final synchronized void close() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
    }

    @Override
    public final synchronized boolean isClosed() throws SQLException {
        if (this.connection != null) {
            return this.connection.isClosed();
        }
        return true;
    }

    @Override
    public final synchronized DatabaseMetaData getMetaData() throws SQLException {
        return this.getConnection().getMetaData();
    }

    @Override
    public final synchronized void setReadOnly(boolean readOnly) throws SQLException {
        this.getConnection().setReadOnly(readOnly);
    }

    @Override
    public final synchronized boolean isReadOnly() throws SQLException {
        return this.getConnection().isReadOnly();
    }

    @Override
    public final synchronized void setCatalog(String catalog) throws SQLException {
        this.getConnection().setCatalog(catalog);
    }

    @Override
    public final synchronized String getCatalog() throws SQLException {
        return this.getConnection().getCatalog();
    }

    @Override
    public final synchronized void setTransactionIsolation(int level) throws SQLException {
        this.getConnection().setTransactionIsolation(level);
    }

    @Override
    public final synchronized int getTransactionIsolation() throws SQLException {
        return this.getConnection().getTransactionIsolation();
    }

    @Override
    public final synchronized SQLWarning getWarnings() throws SQLException {
        return this.getConnection().getWarnings();
    }

    @Override
    public final synchronized void clearWarnings() throws SQLException {
        this.getConnection().clearWarnings();
    }

    @Override
    public final synchronized Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.getConnection().createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public final synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.getConnection().prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public final synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.getConnection().prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public final synchronized Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.getConnection().getTypeMap();
    }

    @Override
    public final synchronized void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.getConnection().setTypeMap(map);
    }

    @Override
    public final synchronized void setHoldability(int holdability) throws SQLException {
        this.getConnection().setHoldability(holdability);
    }

    @Override
    public final synchronized int getHoldability() throws SQLException {
        return this.getConnection().getHoldability();
    }

    @Override
    public final synchronized Savepoint setSavepoint() throws SQLException {
        return this.getConnection().setSavepoint();
    }

    @Override
    public final synchronized Savepoint setSavepoint(String name) throws SQLException {
        return this.getConnection().setSavepoint(name);
    }

    @Override
    public final synchronized void rollback(Savepoint savepoint) throws SQLException {
        this.getConnection().rollback(savepoint);
    }

    @Override
    public final synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.getConnection().releaseSavepoint(savepoint);
    }

    @Override
    public final synchronized Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.getConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public final synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.getConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public final synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.getConnection().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public final synchronized PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.getConnection().prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public final synchronized PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.getConnection().prepareStatement(sql, columnIndexes);
    }

    @Override
    public final synchronized PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.getConnection().prepareStatement(sql, columnNames);
    }

    @Override
    public final synchronized Clob createClob() throws SQLException {
        return this.getConnection().createClob();
    }

    @Override
    public final synchronized Blob createBlob() throws SQLException {
        return this.getConnection().createBlob();
    }

    @Override
    public final synchronized NClob createNClob() throws SQLException {
        return this.getConnection().createNClob();
    }

    @Override
    public final synchronized SQLXML createSQLXML() throws SQLException {
        return this.getConnection().createSQLXML();
    }

    @Override
    public final synchronized boolean isValid(int timeout) throws SQLException {
        return this.getConnection().isValid(timeout);
    }

    @Override
    public final synchronized void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.getConnection().setClientInfo(name, value);
        }
        catch (SQLException e) {
            new SQLClientInfoException();
        }
    }

    @Override
    public final synchronized void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.getConnection().setClientInfo(properties);
        }
        catch (SQLException e) {
            new SQLClientInfoException();
        }
    }

    @Override
    public final synchronized String getClientInfo(String name) throws SQLException {
        return this.properties.getProperty(name);
    }

    @Override
    public final synchronized Properties getClientInfo() throws SQLException {
        return this.properties;
    }

    @Override
    public final synchronized Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.getConnection().createArrayOf(typeName, elements);
    }

    @Override
    public final synchronized Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.getConnection().createStruct(typeName, attributes);
    }

    @Override
    public final synchronized void setSchema(String schema) throws SQLException {
        this.getConnection().setSchema(schema);
    }

    @Override
    public final synchronized String getSchema() throws SQLException {
        return this.getConnection().getSchema();
    }

    @Override
    public final synchronized void abort(Executor executor) throws SQLException {
        this.getConnection().abort(executor);
    }

    @Override
    public final synchronized void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.getConnection().setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public final synchronized int getNetworkTimeout() throws SQLException {
        return this.getConnection().getNetworkTimeout();
    }

    public String toString() {
        try {
            return this.getConnection().toString();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object obj) {
        try {
            return this.getConnection().equals(obj);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        try {
            return this.getConnection().hashCode();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

