/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jfreechart;

import java.util.Map;
import java.util.WeakHashMap;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;
import org.ujmp.gui.MatrixGUIObject;

public class XYSeriesWrapper
extends XYSeries {
    private static final long serialVersionUID = 2493663877511719452L;
    private static final int MAXITEMS = 3000;
    private final Map<Integer, XYDataItem> values = new WeakHashMap<Integer, XYDataItem>();
    private MatrixGUIObject matrix = null;
    private ValueMarker meanMarker = null;
    private IntervalMarker standardDeviationMarker = null;
    private IntervalMarker minMaxMarker = null;
    private int seriesId = 0;
    private int stepsize = 1;
    private int start = 0;

    public XYSeriesWrapper(MatrixGUIObject m, int number) {
        super((Comparable)((Object)m.getColumnName(number)), false, true);
        this.seriesId = number;
        this.matrix = m;
    }

    public XYDataItem getDataItem(int index) {
        double row = index;
        try {
            row = Double.parseDouble(this.matrix.getMatrix().getRowLabel(index));
        }
        catch (Exception e) {
            // empty catch block
        }
        return new XYDataItem(row, this.matrix.getMatrix().getAsDouble(index, this.seriesId));
    }

    public int getItemCount() {
        return this.matrix.getRowCount();
    }

    public int indexOf(Number x) {
        return (Integer)x;
    }
}

