/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.gsea;

import edu.mit.broad.genome.Errors;
import edu.mit.broad.genome.MismatchedSizeException;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EdbAlgs {
    public static LabelledVector createRealES(EnrichmentResult[] results) {
        EdbAlgs._nonNull(results);
        Vector v = new Vector(results.length);
        ArrayList<String> labels = new ArrayList<String>();
        for (int i = 0; i < results.length; ++i) {
            labels.add(results[i].getGeneSetName());
            v.setElement(i, results[i].getScore().getES());
        }
        return new LabelledVector(labels, v, true);
    }

    public static Dataset createRndESDataset(String name, EnrichmentResult[] results) {
        EdbAlgs._nonNull(results);
        int numPerms = EdbAlgs.enforceSameNumOfPerms(results);
        Matrix m = new Matrix(results.length, numPerms);
        ArrayList<String> rowNames = new ArrayList<String>(results.length);
        for (int r = 0; r < results.length; ++r) {
            Vector v = results[r].getRndESS();
            m.setRow(r, v);
            rowNames.add(results[r].getGeneSetName());
        }
        return new DefaultDataset(name + "_rnd_es", m, rowNames, EdbAlgs._permColNames(numPerms), true, null);
    }

    public static GeneSet[] getGeneSets(EnrichmentResult[] results) {
        EdbAlgs._nonNull(results);
        GeneSet[] gsets = new GeneSet[results.length];
        for (int r = 0; r < results.length; ++r) {
            gsets[r] = results[r].getGeneSet();
        }
        return gsets;
    }

    private static void _nonNull(EnrichmentResult[] results) {
        if (results == null || results.length == 0) {
            throw new IllegalArgumentException("Param results cannot be null nor zero length: " + results);
        }
    }

    public static Map hashByGeneSetName(EnrichmentResult[] results) {
        EdbAlgs._nonNull(results);
        HashMap<String, EnrichmentResult> map = new HashMap<String, EnrichmentResult>();
        Errors errors = new Errors();
        for (int i = 0; i < results.length; ++i) {
            String name = results[i].getGeneSet().getName(true);
            if (map.containsKey(name)) {
                errors.add("Duplicated gene set: " + name);
                continue;
            }
            map.put(name, results[i]);
        }
        errors.barfIfNotEmptyRuntime();
        return map;
    }

    public static List getGeneSetNames(EnrichmentResult[] results) {
        EdbAlgs._nonNull(results);
        ArrayList<String> list = new ArrayList<String>(results.length);
        for (int i = 0; i < results.length; ++i) {
            list.add(results[i].getGeneSet().getName(true));
        }
        return list;
    }

    public static int enforceSameNumOfPerms(EnrichmentResult[] results) {
        if (results.length == 0) {
            return 0;
        }
        int num = results[0].getNumPerms();
        for (int i = 0; i < results.length; ++i) {
            if (results[i].getNumPerms() == num) continue;
            throw new MismatchedSizeException("enrichment result: " + results[0].getGeneSetName(), num, "enrichment result: " + results[i].getGeneSetName(), results[i].getNumPerms());
        }
        return num;
    }

    private static List _permColNames(int nperms) {
        ArrayList<CallSite> colNames = new ArrayList<CallSite>();
        for (int c = 0; c < nperms; ++c) {
            colNames.add((CallSite)((Object)("perm_" + (c + 1))));
        }
        return colNames;
    }
}

