/*
 * Decompiled with CFR 0.152.
 */
package org.igv.util.stream;

import htsjdk.samtools.seekablestream.ISeekableStreamFactory;
import htsjdk.samtools.seekablestream.SeekableFileStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.igv.util.FileUtils;
import org.igv.util.HttpUtils;
import org.igv.util.stream.IGVSeekableBufferedStream;
import org.igv.util.stream.IGVSeekableFTPStream;
import org.igv.util.stream.IGVSeekableHTTPStream;
import org.igv.util.stream.SeekableSplitStream;

public class IGVSeekableStreamFactory
implements ISeekableStreamFactory {
    private static IGVSeekableStreamFactory instance = new IGVSeekableStreamFactory();

    private IGVSeekableStreamFactory() {
    }

    public static IGVSeekableStreamFactory getInstance() {
        return instance;
    }

    public SeekableStream getStreamFor(URL url) throws IOException {
        return this.getStreamFor(url.toExternalForm());
    }

    public SeekableStream getStreamFor(String path) throws IOException {
        if (path.endsWith(".list")) {
            return new SeekableSplitStream(path);
        }
        path = this.mapPath(path);
        SeekableStream is = null;
        if (FileUtils.isRemote(path)) {
            URL url = HttpUtils.createURL(path);
            is = new IGVSeekableHTTPStream(url);
        } else if (path.toLowerCase().startsWith("ftp:")) {
            URL url = HttpUtils.createURL(path);
            is = new IGVSeekableFTPStream(url);
        } else {
            is = new SeekableFileStream(new File(path));
        }
        return is;
    }

    public SeekableStream getBufferedStream(SeekableStream stream) {
        return this.getBufferedStream(stream, 512000);
    }

    public SeekableStream getBufferedStream(SeekableStream stream, int bufferSize) {
        return new IGVSeekableBufferedStream(stream, bufferSize);
    }

    private String mapPath(String path) {
        if (path.startsWith("ftp://ftp.ncbi.nlm.nih.gov/geo")) {
            return path.replace("ftp://ftp.ncbi.nlm.nih.gov/geo", "https://ftp.ncbi.nlm.nih.gov/geo");
        }
        return path;
    }
}

