/*
 * Decompiled with CFR 0.152.
 */
package org.igv.util.stats;

import java.io.PrintWriter;

public class Distribution {
    private int minBin = 0;
    private int maxBin;
    private int nBins;
    private final double[] freq;
    private int n;

    public Distribution(int maxBin) {
        this.maxBin = maxBin;
        int nBins = maxBin - this.minBin + 1;
        this.freq = new double[nBins];
    }

    public Distribution(int minBin, int maxBin) {
        this.minBin = minBin;
        this.maxBin = maxBin;
        int nBins = maxBin - minBin + 1;
        this.freq = new double[nBins];
    }

    public void addDataPoint(int i) {
        int idx;
        int bin = i - this.minBin;
        int n = idx = Math.max(0, Math.min(this.nBins - 1, i));
        this.freq[n] = this.freq[n] + 1.0;
        ++this.n;
    }

    public double[] getDist() {
        return this.freq;
    }

    public void print(PrintWriter pw) {
        boolean start = false;
        for (int i = 0; i <= this.maxBin; ++i) {
            start = true;
            float frac = (float)this.freq[i] / (float)this.n;
            pw.println(i - this.minBin + "\t" + this.freq[i]);
        }
    }
}

