/*
 * Decompiled with CFR 0.152.
 */
package org.igv.util.liftover;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.igv.Globals;
import org.igv.feature.Range;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.util.ParsingUtils;
import org.igv.util.liftover.Chain;

public class Liftover {
    private static Logger log = LogManager.getLogger(Liftover.class);
    Map<String, Chain> chains = new HashMap<String, Chain>();

    Liftover(List<Chain> chains) {
        for (Chain c : chains) {
            this.chains.put(c.tName, c);
        }
    }

    public List<Range> map(Range range) {
        if (this.chains.containsKey(range.getChr())) {
            List<Range> mapped = this.chains.get(range.getChr()).map(range);
            ArrayList<Range> combined = new ArrayList<Range>();
            if (mapped.size() > 0) {
                Collections.sort(mapped, (o1, o2) -> {
                    if (o1.getChr().equals(o2.getChr())) {
                        return o1.getStart() - o2.getStart();
                    }
                    return o1.getChr().compareTo(o2.getChr());
                });
                Range lastRange = mapped.get(0);
                combined.add(lastRange);
                for (int i = 1; i < mapped.size(); ++i) {
                    Range currentRange = mapped.get(i);
                    if (currentRange.getChr().equals(lastRange.getChr()) && lastRange.end == mapped.get((int)i).start) {
                        lastRange.end = currentRange.end;
                        continue;
                    }
                    lastRange = currentRange;
                    combined.add(lastRange);
                }
            }
            return combined;
        }
        return Collections.EMPTY_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Liftover load(String path) throws IOException {
        BufferedReader br = null;
        try {
            br = ParsingUtils.openBufferedReader(path);
            ArrayList<Chain> chains = new ArrayList<Chain>();
            Chain chain = null;
            ArrayList<String[]> data = new ArrayList<String[]>();
            String line = "";
            while ((line = br.readLine()) != null) {
                if ((line = line.strip()).length() == 0) {
                    if (chain == null) continue;
                    chain.setAlignments(data);
                    chains.add(chain);
                    chain = null;
                    data.clear();
                    continue;
                }
                if (line.startsWith("chain")) {
                    String[] t = Globals.whitespacePattern.split(line);
                    chain = new Chain(t[2], Integer.parseInt(t[3]), Integer.parseInt(t[5]), Integer.parseInt(t[6]), t[7], Integer.parseInt(t[8]), Integer.parseInt(t[10]), Integer.parseInt(t[11]), t[12]);
                    continue;
                }
                data.add(Globals.whitespacePattern.split(line));
            }
            if (chain != null && data.size() > 0) {
                chain.setAlignments(data);
                chains.add(chain);
            }
            Liftover liftover = new Liftover(chains);
            return liftover;
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                log.error("Error closing chaing file", e);
            }
        }
    }
}

