/*
 * Decompiled with CFR 0.152.
 */
package org.igv.util.liftover;

import java.util.ArrayList;
import java.util.List;
import org.igv.feature.Range;
import org.igv.util.Interval;
import org.igv.util.IntervalTree;

public class Chain {
    String tName;
    int tSize;
    int tStart;
    int tEnd;
    String qName;
    int qSize;
    int qStart;
    int qEnd;
    String id;
    IntervalTree<int[]> tree;

    public Chain(String tName, int tSize, int tStart, int tEnd, String qName, int qSize, int qStart, int qEnd, String id) {
        this.tName = tName;
        this.tSize = tSize;
        this.tStart = tStart;
        this.tEnd = tEnd;
        this.qName = qName;
        this.qSize = qSize;
        this.qStart = qStart;
        this.qEnd = qEnd;
        this.id = id;
    }

    public void setAlignments(List<String[]> lines) {
        this.tree = new IntervalTree();
        int tStart = this.tStart;
        int qStart = this.qStart;
        for (String[] line : lines) {
            int size = Integer.parseInt(line[0]);
            int tEnd = tStart + size;
            int qEnd = qStart + size;
            int[] value = new int[]{qStart, qEnd};
            this.tree.insert(new Interval<int[]>(tStart, tEnd, value));
            if (line.length != 3) continue;
            tStart += size + Integer.parseInt(line[1]);
            qStart += size + Integer.parseInt(line[2]);
        }
    }

    public List<Range> map(Range span) {
        List<Interval<int[]>> intervals;
        ArrayList<Range> mapped = new ArrayList<Range>();
        if (span.getChr().equals(this.tName) && (intervals = this.tree.findOverlapping(span.start, span.end)) != null) {
            for (Interval<int[]> interval : intervals) {
                int ds = span.start - interval.getLow();
                int[] qspan = interval.getValue();
                int start = Math.max(qspan[0], qspan[0] + ds);
                int end = Math.min(qspan[1], qspan[0] + span.getLength() + ds);
                Range mappedSpan = new Range(this.qName, start, end);
                mapped.add(mappedSpan);
            }
        }
        return mapped;
    }
}

