/*
 * Decompiled with CFR 0.152.
 */
package org.igv.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import org.igv.exceptions.DataLoadException;

public class MD5Checksum {
    private static byte[] createChecksum(String filename) throws Exception {
        int numRead;
        FileInputStream fis = new FileInputStream(filename);
        byte[] buffer = new byte[1024];
        MessageDigest complete = MessageDigest.getInstance("MD5");
        do {
            if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
            complete.update(buffer, 0, numRead);
        } while (numRead != -1);
        ((InputStream)fis).close();
        return complete.digest();
    }

    public static String getMD5Checksum(String filename) throws Exception {
        File fileName = new File(filename);
        if (fileName.isFile()) {
            byte[] b = MD5Checksum.createChecksum(filename);
            Object result = "";
            for (int i = 0; i < b.length; ++i) {
                result = (String)result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
            }
            return result;
        }
        throw new DataLoadException("No file found", filename);
    }
}

