/*
 * Decompiled with CFR 0.152.
 */
package org.igv.util;

import java.io.UnsupportedEncodingException;
import java.security.InvalidParameterException;
import java.util.Base64;
import org.json.JSONObject;

public class JWTParser {
    private static final int HEADER = 0;
    private static final int PAYLOAD = 1;
    private static final int SIGNATURE = 2;
    private static final int JWT_PARTS = 3;

    static JSONObject getHeader(String jwt) {
        try {
            JWTParser.validateJWT(jwt);
            Base64.Decoder dec = Base64.getDecoder();
            byte[] sectionDecoded = dec.decode(jwt.split("\\.")[0]);
            String jwtSection = new String(sectionDecoded, "UTF-8");
            return new JSONObject(jwtSection);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        catch (Exception e) {
            throw new InvalidParameterException("error in parsing JSON");
        }
    }

    public static JSONObject getPayload(String jwt) {
        try {
            JWTParser.validateJWT(jwt);
            Base64.Decoder dec = Base64.getDecoder();
            String payload = jwt.split("\\.")[1];
            byte[] sectionDecoded = dec.decode(payload);
            String jwtSection = new String(sectionDecoded, "UTF-8");
            return new JSONObject(jwtSection);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        catch (Exception e) {
            throw new InvalidParameterException("error in parsing JSON");
        }
    }

    public static String getSignature(String jwt) {
        try {
            JWTParser.validateJWT(jwt);
            Base64.Decoder dec = Base64.getDecoder();
            byte[] sectionDecoded = dec.decode(jwt.split("\\.")[2]);
            return new String(sectionDecoded, "UTF-8");
        }
        catch (Exception e) {
            throw new InvalidParameterException("error in parsing JSON");
        }
    }

    static String getClaim(String jwt, String claim) {
        try {
            JSONObject payload = JWTParser.getPayload(jwt);
            Object claimValue = payload.opt(claim);
            if (claimValue != null) {
                return claimValue.toString();
            }
        }
        catch (Exception e) {
            throw new InvalidParameterException("invalid token");
        }
        return null;
    }

    static void validateJWT(String jwt) {
        String[] jwtParts = jwt.split("\\.");
        if (jwtParts.length != 3) {
            throw new InvalidParameterException("not a JSON Web Token");
        }
    }
}

