/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui.util;

import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.index.IndexFactory;
import htsjdk.tribble.index.linear.LinearIndex;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import org.igv.exceptions.DataLoadException;
import org.igv.feature.genome.GenomeManager;
import org.igv.feature.tribble.CodecFactory;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.sam.reader.AlignmentIndexer;
import org.igv.sam.reader.FeatureIndex;
import org.igv.tools.IgvTools;
import org.igv.ui.IGVDialog;
import org.igv.ui.util.MessageUtils;
import org.igv.ui.util.UIUtilities;
import org.igv.util.ResourceLocator;

public class IndexCreatorDialog
extends IGVDialog {
    private static Logger log = LogManager.getLogger(IndexCreatorDialog.class);
    File file;
    File idxFile;
    IndexWorker worker;
    FileType fileType;
    String introText;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JScrollPane scrollPane1;
    private JTextPane introTextArea;
    private JLabel timeRemainingLabel;
    private JLabel jLabel1;
    private JProgressBar progressBar;
    private JPanel buttonBar;
    private JButton goButton;
    private JButton cancelButton;

    public static IndexCreatorDialog createShowDialog(Frame parent, File baseFile, File newIdxFile, String introText) {
        final IndexCreatorDialog dialog = new IndexCreatorDialog(parent, true, baseFile, newIdxFile, introText);
        dialog.setLocationRelativeTo(parent);
        UIUtilities.invokeAndWaitOnEventThread(new Runnable(){

            @Override
            public void run() {
                dialog.setVisible(true);
            }
        });
        return dialog;
    }

    public IndexCreatorDialog(Frame parent, boolean modal, File file, File idxFile, String introText) {
        super(parent, modal);
        this.initComponents();
        this.introText = introText;
        this.jLabel1.setVisible(false);
        this.file = file;
        this.idxFile = idxFile;
        this.determineFileType(file);
        if (this.fileType == null) {
            log.error("Cannot determine file type for " + file.getAbsolutePath());
        }
        String txt = introText;
        this.introTextArea.setText(txt);
        this.introTextArea.setBorder(BorderFactory.createEmptyBorder());
        switch (this.fileType.ordinal()) {
            case 0: {
                this.worker = new SamIndexWorker();
                break;
            }
            case 1: {
                this.worker = new TribbleIndexWorker();
            }
        }
    }

    private void determineFileType(File file) {
        String filename = file.getName();
        this.fileType = filename.toLowerCase().endsWith(".sam") ? FileType.SAM : (CodecFactory.hasCodec(new ResourceLocator(file.getPath()), null) ? FileType.TRIBBLE : null);
    }

    public Object getIndex() {
        if (this.worker == null || !this.worker.isDone()) {
            return null;
        }
        try {
            return this.worker.get();
        }
        catch (Exception ex) {
            MessageUtils.showMessage(ex.getMessage());
            return null;
        }
    }

    private void goButtonActionPerformed(ActionEvent evt) {
        if (this.worker.isDone() || this.worker.isCancelled()) {
            this.setVisible(false);
        } else if (!this.worker.isStarted) {
            this.goButton.setEnabled(false);
            this.worker.isStarted = true;
            this.worker.execute();
            this.jLabel1.setVisible(true);
            if (this.fileType == FileType.TRIBBLE) {
                this.progressBar.setIndeterminate(true);
                this.jLabel1.setText("Creating index...");
            }
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        if (this.worker != null && this.worker.isStarted && !this.worker.isDone() && !this.worker.isCancelled()) {
            this.worker.isStarted = false;
            this.worker.cancel(true);
        }
        this.setVisible(false);
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.scrollPane1 = new JScrollPane();
        this.introTextArea = new JTextPane();
        this.timeRemainingLabel = new JLabel();
        this.jLabel1 = new JLabel();
        this.progressBar = new JProgressBar();
        this.buttonBar = new JPanel();
        this.goButton = new JButton();
        this.cancelButton = new JButton();
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(null);
        this.scrollPane1.setViewportView(this.introTextArea);
        this.contentPanel.add(this.scrollPane1);
        this.scrollPane1.setBounds(0, 0, 465, 260);
        this.contentPanel.add(this.timeRemainingLabel);
        this.timeRemainingLabel.setBounds(255, 265, 210, 31);
        this.jLabel1.setHorizontalTextPosition(4);
        this.contentPanel.add(this.jLabel1);
        this.jLabel1.setBounds(0, 265, 210, 31);
        this.contentPanel.add(this.progressBar);
        this.progressBar.setBounds(0, 305, 465, this.progressBar.getPreferredSize().height);
        Dimension preferredSize = new Dimension();
        for (int i = 0; i < this.contentPanel.getComponentCount(); ++i) {
            Rectangle bounds = this.contentPanel.getComponent(i).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        Insets insets = this.contentPanel.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.contentPanel.setMinimumSize(preferredSize);
        this.contentPanel.setPreferredSize(preferredSize);
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.goButton.setText("Go");
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndexCreatorDialog.this.goButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.goButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndexCreatorDialog.this.cancelButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.setSize(500, 415);
        this.setLocationRelativeTo(this.getOwner());
    }

    private static enum FileType {
        SAM,
        TRIBBLE;

    }

    public class SamIndexWorker
    extends IndexWorker<FeatureIndex> {
        @Override
        protected FeatureIndex doInBackground() throws Exception {
            AlignmentIndexer indexer = AlignmentIndexer.getInstance(IndexCreatorDialog.this.file, IndexCreatorDialog.this.progressBar, this);
            return indexer.createSamIndex(IndexCreatorDialog.this.idxFile, 16000);
        }
    }

    public abstract class IndexWorker<I>
    extends SwingWorker<I, Void> {
        private boolean isStarted = false;

        @Override
        protected void done() {
            IndexCreatorDialog.this.setVisible(false);
        }

        public void setTimeRemaining(long timeInMillis) {
            final int timeRemaining = (int)(timeInMillis / 60000L);
            UIUtilities.invokeOnEventThread(new Runnable(){

                @Override
                public void run() {
                    Object txt = String.valueOf(timeRemaining) + " minutes";
                    if (timeRemaining == 1) {
                        txt = "1 minute";
                    } else if (timeRemaining < 1) {
                        txt = " < 1 minute";
                    }
                    IndexCreatorDialog.this.timeRemainingLabel.setText((String)txt);
                }
            });
        }
    }

    private class TribbleIndexWorker
    extends IndexWorker<Index> {
        private TribbleIndexWorker() {
        }

        @Override
        protected Index doInBackground() throws Exception {
            int binSize = 16000;
            FeatureCodec codec = CodecFactory.getCodec(IndexCreatorDialog.this.file.getAbsolutePath(), GenomeManager.getInstance().getCurrentGenome());
            if (codec != null) {
                try {
                    LinearIndex index = IndexFactory.createLinearIndex((File)IndexCreatorDialog.this.file, (FeatureCodec)codec, (int)binSize);
                    if (index != null) {
                        IgvTools.writeTribbleIndex((Index)index, IndexCreatorDialog.this.idxFile.getAbsolutePath());
                    }
                    return index;
                }
                catch (TribbleException.MalformedFeatureFile e) {
                    StringBuffer buf = new StringBuffer();
                    buf.append("<html>Files must be sorted by start position prior to indexing.<br>");
                    buf.append(e.getMessage());
                    buf.append("<br><br>Note: igvtools can be used to sort the file, select \"File > Run igvtools...\".");
                    MessageUtils.showMessage(buf.toString());
                }
            } else {
                throw new DataLoadException("Unknown File Type", IndexCreatorDialog.this.file.getAbsolutePath());
            }
            return null;
        }
    }

    class ProgressListener
    implements PropertyChangeListener {
        private JProgressBar progressBar;

        private ProgressListener(IndexCreatorDialog this$0) {
        }

        ProgressListener(IndexCreatorDialog this$0, JProgressBar progressBar) {
            this.progressBar = progressBar;
            this.progressBar.setValue(0);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String strPropertyName = evt.getPropertyName();
            if ("progress".equals(strPropertyName)) {
                this.progressBar.setIndeterminate(false);
                int progress = (Integer)evt.getNewValue();
                this.progressBar.setValue(progress);
            }
        }
    }
}

