/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui.util;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.igv.DirectoryManager;
import org.igv.Globals;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.ui.IGV;

public class FileDialogUtils {
    public static int LOAD = 0;
    public static int SAVE = 1;
    private static Logger log = LogManager.getLogger(FileDialogUtils.class);

    public static File chooseFile(String title, File initialDirectory, int mode) {
        return FileDialogUtils.chooseFile(title, initialDirectory, null, mode);
    }

    public static File chooseFile(String title) {
        return FileDialogUtils.chooseFile(title, DirectoryManager.getUserDefaultDirectory(), null, 0);
    }

    public static File chooseFile(String title, File initialDirectory, File initialFile, int mode) {
        return FileDialogUtils.chooseFile(title, initialDirectory, initialFile, null, 0, mode);
    }

    private static File chooseFile(String title, File initialDirectory, File initialFile, FilenameFilter filter, int directoriesMode, int mode) {
        File[] files;
        File file = null;
        if (initialDirectory == null && initialFile != null) {
            initialDirectory = initialFile.getParentFile();
        }
        if (initialFile != null) {
            initialFile = new File(initialFile.getName());
        }
        file = Globals.FORCE_SWING_DIALOG ? ((files = FileDialogUtils.chooseSwing(title, initialDirectory, initialFile, filter, directoriesMode, mode)) != null && files.length > 0 ? files[0] : null) : FileDialogUtils.chooseNative(title, initialDirectory, initialFile, filter, directoriesMode, mode);
        return file;
    }

    public static File chooseDirectory(String title, File initialDirectory) {
        if (Globals.IS_MAC) {
            return FileDialogUtils.chooseNative(title, initialDirectory, null, null, 1, LOAD);
        }
        File[] files = FileDialogUtils.chooseSwing(title, initialDirectory, null, null, 1, LOAD);
        return files != null && files.length > 0 ? files[0] : null;
    }

    public static File[] chooseMultiple(String title, File initialDirectory, FilenameFilter filter) {
        File[] files = null;
        if (Globals.FORCE_SWING_DIALOG) {
            File[] selectedFiles;
            files = selectedFiles = FileDialogUtils.chooseSwing(title, initialDirectory, null, filter, 0, LOAD, true);
        } else {
            FileDialog fd = FileDialogUtils.getNativeChooser(title, initialDirectory, null, filter, 0, LOAD);
            if (fd.isMultipleMode()) {
                fd.setVisible(true);
                files = fd.getFiles();
            }
        }
        return files;
    }

    private static FileDialog getNativeChooser(String title, File initialDirectory, File initialFile, FilenameFilter filter, int directoryMode, int mode) {
        boolean directories = 1 == directoryMode;
        System.setProperty("apple.awt.fileDialogForDirectories", String.valueOf(directories));
        Frame parentFrame = FileDialogUtils.getParentFrame();
        FileDialog fd = new FileDialog(parentFrame, title);
        if (initialDirectory != null) {
            fd.setDirectory(initialDirectory.getAbsolutePath());
        }
        if (initialFile != null) {
            fd.setFile(initialFile.getName());
        }
        if (filter != null) {
            fd.setFilenameFilter(filter);
        }
        fd.setModal(true);
        fd.setMode(mode);
        if (mode == LOAD && !directories) {
            FileDialogUtils.setMultipleMode(fd, true);
        }
        return fd;
    }

    private static File chooseNative(String title, File initialDirectory, File initialFile, FilenameFilter filter, int directoryMode, int mode) {
        FileDialog fd = FileDialogUtils.getNativeChooser(title, initialDirectory, initialFile, filter, directoryMode, mode);
        fd.setVisible(true);
        String file = fd.getFile();
        String directory = fd.getDirectory();
        if (file != null && directory != null) {
            if (Globals.IS_MAC && initialFile != null) {
                file = FileDialogUtils.fixMacExtension(initialFile, file);
            }
            return new File(directory, file);
        }
        return null;
    }

    private static File[] chooseSwing(String title, File initialDirectory, File initialFile, FilenameFilter filter, int directoryMode, int mode) {
        return FileDialogUtils.chooseSwing(title, initialDirectory, initialFile, filter, directoryMode, mode, false);
    }

    private static File[] chooseSwing(String title, File initialDirectory, File initialFile, FilenameFilter filter, int directoryMode, int mode, boolean multiSelectionEnabled) {
        boolean approve;
        UIManager.put("FileChooser.readOnly", Boolean.FALSE);
        JFileChooser fileChooser = FileDialogUtils.getJFileChooser(title, initialDirectory, initialFile, filter, directoryMode);
        fileChooser.setMultiSelectionEnabled(multiSelectionEnabled);
        Frame parentFrame = FileDialogUtils.getParentFrame();
        if (mode == LOAD) {
            approve = fileChooser.showOpenDialog(parentFrame) == 0;
        } else {
            boolean bl = approve = fileChooser.showSaveDialog(parentFrame) == 0;
        }
        if (approve) {
            File[] fileArray;
            if (mode == LOAD && multiSelectionEnabled) {
                return fileChooser.getSelectedFiles();
            }
            File selected = fileChooser.getSelectedFile();
            if (selected != null) {
                File[] fileArray2 = new File[1];
                fileArray = fileArray2;
                fileArray2[0] = selected;
            } else {
                fileArray = null;
            }
            return fileArray;
        }
        return null;
    }

    private static JFileChooser getJFileChooser(String title, File initialDirectory, File initialFile, final FilenameFilter filter, int directoryMode) {
        JFileChooser fileChooser = new JFileChooser();
        if (initialDirectory != null) {
            fileChooser.setCurrentDirectory(initialDirectory);
        }
        if (initialFile != null) {
            fileChooser.setSelectedFile(initialFile);
        }
        if (filter != null) {
            fileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return filter.accept(file.getParentFile(), file.getName());
                }

                @Override
                public String getDescription() {
                    return "";
                }
            });
        }
        fileChooser.setDialogTitle(title);
        fileChooser.setFileSelectionMode(directoryMode);
        return fileChooser;
    }

    private static boolean setMultipleMode(FileDialog fd, boolean b) {
        try {
            Method method = FileDialog.class.getMethod("setMultipleMode", Boolean.TYPE);
            method.invoke((Object)fd, b);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String fixMacExtension(File initialFile, String fname) {
        if (fname.contains(".")) {
            return fname;
        }
        String initialName = initialFile.getName();
        int idx = initialName.lastIndexOf(".");
        if (idx > 0) {
            String ext = initialName.substring(idx);
            return fname + ext;
        }
        return fname;
    }

    private static Frame getParentFrame() {
        return IGV.hasInstance() ? IGV.getInstance().getMainFrame() : null;
    }
}

