/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui.svg;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.PrintWriter;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.igv.ui.color.ColorUtilities;

public class SVGGraphics
extends Graphics2D {
    PrintWriter outputStream;
    Color color = Color.black;
    Color background = Color.white;
    BasicStroke stroke;
    Font font;
    FontRenderContext fontRenderContext;
    FontMetrics fontMetrics;
    AffineTransform transform;
    JComponent component;
    int translateX;
    int translateY;
    String clipRef;
    static int clipNumber = 0;
    Shape clip;

    public SVGGraphics(PrintWriter outputStream, Rectangle clip) {
        this.clip = clip;
        this.initDefaults();
        this.outputStream = outputStream;
    }

    public SVGGraphics(SVGGraphics g) {
        this.clip = g.clip;
        this.outputStream = g.outputStream;
        this.color = g.color;
        this.background = g.background;
        this.stroke = g.stroke;
        this.font = g.font;
        this.fontMetrics = g.fontMetrics;
        this.fontRenderContext = g.fontRenderContext;
        this.component = g.component;
        if (g.transform != null) {
            this.transform = new AffineTransform(g.transform);
        }
        this.clipRef = g.clipRef;
        this.translateX = g.translateX;
        this.translateY = g.translateY;
    }

    private void initDefaults() {
        this.component = new JPanel();
        this.stroke = new BasicStroke();
        this.color = Color.black;
        this.font = new Font("Arial", 0, 12);
        this.fontMetrics = this.component.getFontMetrics(this.font);
        this.fontRenderContext = new FontRenderContext(null, true, false);
        this.translateX = 0;
        this.translateY = 0;
    }

    @Override
    public void drawString(String s, int x, int y) {
        int tx = this.translateX + x;
        int ty = this.translateY + y;
        this.outputStream.print("<text x=\"");
        this.outputStream.print(tx);
        this.outputStream.print("\" y=\"");
        this.outputStream.print(ty);
        this.outputStream.println("\"");
        this.outputStream.print(" style=\"font-family: " + this.font.getName() + ";");
        this.outputStream.print(" font-size:" + this.font.getSize() + ";");
        if (this.font.isBold()) {
            this.outputStream.print(" font-weight: bold;");
        }
        this.outputStream.print(" fill:rgb" + this.getRGBString());
        if (this.clipRef != null) {
            this.outputStream.print(";clip-path: " + this.clipRef);
        }
        this.outputStream.print("\" ");
        this.applyTransform();
        this.outputStream.print(">");
        this.outputStream.print(s);
        this.outputStream.println("</text>");
    }

    @Override
    public void setStroke(Stroke stroke) {
        if (!(stroke instanceof BasicStroke)) {
            // empty if block
        }
        this.stroke = (BasicStroke)stroke;
    }

    @Override
    public Graphics create() {
        return new SVGGraphics(this);
    }

    @Override
    public void translate(int x, int y) {
        this.translateX += x;
        this.translateY += y;
    }

    @Override
    public void setClip(int x, int y, int w, int h) {
        this.clip = new Rectangle(x, y, w, h);
        int tx = this.translateX + x;
        int ty = this.translateY + y;
        String id = SVGGraphics.getClipId();
        this.outputStream.println("<clipPath id=\"" + id + "\">\n    <rect id=\"rect1\" x=\"" + tx + "\" y=\"" + ty + "\"\n       width=\"" + w + "\" height=\"" + h + "\"/>");
        this.outputStream.println("</clipPath>");
        this.clipRef = "url(#" + id + ")";
    }

    private static synchronized String getClipId() {
        return "clip_" + clipNumber++;
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        int tx1 = this.translateX + x1;
        int ty1 = this.translateY + y1;
        int tx2 = this.translateX + x2;
        int ty2 = this.translateY + y2;
        String rgbString = this.getRGBString();
        float strokeWidth = this.stroke.getLineWidth();
        this.outputStream.println("<line x1=\"" + tx1 + "\" y1=\"" + ty1 + "\" x2=\"" + tx2 + "\" y2=\"" + ty2 + "\"");
        this.outputStream.print("style=\"stroke:rgb" + rgbString + ";stroke-width:" + strokeWidth);
        if (this.clipRef != null) {
            this.outputStream.print(";clip-path: " + this.clipRef);
        }
        this.applyTransform();
        this.outputStream.println("\"/>");
    }

    @Override
    public void drawRect(int x, int y, int w, int h) {
        int tx = this.translateX + x;
        int ty = this.translateY + y;
        String rgbString = this.getRGBString();
        float strokeWidth = this.stroke.getLineWidth();
        this.outputStream.print("<rect x=\"");
        this.outputStream.print(tx);
        this.outputStream.print("\" y=\"");
        this.outputStream.print(ty);
        this.outputStream.print("\" width=\"");
        this.outputStream.print(w);
        this.outputStream.print("\" height=\"");
        this.outputStream.print(h);
        this.outputStream.println("\"");
        this.outputStream.print("  style=\"fill:none;stroke-width:" + strokeWidth + ";stroke:rgb" + rgbString);
        if (this.clipRef != null) {
            this.outputStream.print(";clip-path: " + this.clipRef);
        }
        this.applyTransform();
        this.outputStream.println("\"/>");
    }

    @Override
    public void fillRect(int x, int y, int w, int h) {
        int tx = this.translateX + x;
        int ty = this.translateY + y;
        String rgbString = this.getRGBString();
        float strokeWidth = this.stroke.getLineWidth();
        this.outputStream.print("<rect x=\"");
        this.outputStream.print(tx);
        this.outputStream.print("\" y=\"");
        this.outputStream.print(ty);
        this.outputStream.print("\" width=\"");
        this.outputStream.print(w);
        this.outputStream.print("\" height=\"");
        this.outputStream.print(h);
        this.outputStream.println("\"");
        this.outputStream.print("  style=\"fill:rgb" + rgbString);
        if (this.clipRef != null) {
            this.outputStream.print(";clip-path: " + this.clipRef);
        }
        this.applyTransform();
        this.outputStream.println("\"/>");
    }

    @Override
    public void drawPolygon(int[] x, int[] y, int npts) {
        String rgbString = this.getRGBString();
        float strokeWidth = this.stroke.getLineWidth();
        this.outputStream.print("<polygon points=\"");
        for (int i = 0; i < npts; ++i) {
            int tx = this.translateX + x[i];
            int ty = this.translateY + y[i];
            this.outputStream.print(tx);
            this.outputStream.print(",");
            this.outputStream.print(ty);
            this.outputStream.print(" ");
        }
        this.outputStream.println("\"");
        this.outputStream.print("  style=\"fill:none;stroke-width:" + strokeWidth + ";stroke:rgb" + rgbString);
        if (this.clipRef != null) {
            this.outputStream.print(";clip-path: " + this.clipRef);
        }
        this.applyTransform();
        this.outputStream.println("\"/>");
    }

    @Override
    public void fillPolygon(int[] x, int[] y, int npts) {
        String rgbString = this.getRGBString();
        float strokeWidth = this.stroke.getLineWidth();
        this.outputStream.print("<polygon points=\"");
        for (int i = 0; i < npts; ++i) {
            int tx = this.translateX + x[i];
            int ty = this.translateY + y[i];
            this.outputStream.print(tx);
            this.outputStream.print(",");
            this.outputStream.print(ty);
            this.outputStream.print(" ");
        }
        this.outputStream.println("\"");
        this.outputStream.print("  style=\"fill:rgb" + rgbString);
        if (this.clipRef != null) {
            this.outputStream.print(";clip-path: " + this.clipRef);
        }
        this.applyTransform();
        this.outputStream.println("\"/>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearRect(int x, int y, int w, int h) {
        Color c = this.color;
        try {
            this.color = this.background;
            this.fillRect(x, y, w, h);
        }
        finally {
            this.color = c;
        }
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        if (this.transform == null) {
            this.setTransform(affineTransform);
        } else {
            this.transform.concatenate(affineTransform);
        }
    }

    private void applyTransform() {
        if (this.transform != null) {
            double[] matrix = new double[6];
            this.transform.getMatrix(matrix);
            this.outputStream.print(" transform=\"matrix(");
            for (int i = 0; i < matrix.length; ++i) {
                this.outputStream.print(matrix[i]);
                if (i >= matrix.length - 1) continue;
                this.outputStream.print(" ");
            }
            this.outputStream.println(")\" ");
        }
    }

    private String getRGBString() {
        String rgbString = ColorUtilities.colorToString(this.color);
        return "(" + rgbString + ")";
    }

    @Override
    public Shape getClip() {
        return this.clip;
    }

    @Override
    public void setClip(Shape shape) {
        this.clip = shape;
        Rectangle bounds = shape.getBounds();
        this.setClip(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    @Override
    public void setTransform(AffineTransform affineTransform) {
        this.transform = affineTransform;
    }

    @Override
    public FontMetrics getFontMetrics() {
        return this.fontMetrics;
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return this.component.getFontMetrics(font);
    }

    @Override
    public Rectangle getClipBounds() {
        return this.clip.getBounds();
    }

    @Override
    public void clipRect(int x, int y, int w, int h) {
        this.setClip(x, y, w, h);
    }

    @Override
    public void translate(double x, double y) {
        System.out.println("Translate " + x + " " + y);
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
        this.fontMetrics = this.component.getFontMetrics(font);
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setXORMode(Color color) {
    }

    @Override
    public void copyArea(int i, int i1, int i2, int i3, int i4, int i5) {
    }

    @Override
    public void drawRoundRect(int i, int i1, int i2, int i3, int i4, int i5) {
    }

    @Override
    public void fillRoundRect(int i, int i1, int i2, int i3, int i4, int i5) {
    }

    @Override
    public void drawOval(int i, int i1, int i2, int i3) {
    }

    @Override
    public void fillOval(int i, int i1, int i2, int i3) {
    }

    @Override
    public void drawArc(int i, int i1, int i2, int i3, int i4, int i5) {
    }

    @Override
    public void fillArc(int i, int i1, int i2, int i3, int i4, int i5) {
    }

    @Override
    public void drawPolyline(int[] ints, int[] ints1, int i) {
    }

    @Override
    public void rotate(double v) {
    }

    @Override
    public void rotate(double v, double v1, double v2) {
    }

    @Override
    public void scale(double v, double v1) {
    }

    @Override
    public void shear(double v, double v1) {
    }

    @Override
    public void setRenderingHint(RenderingHints.Key key, Object o) {
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key key) {
        return null;
    }

    @Override
    public void setRenderingHints(Map<?, ?> map) {
    }

    @Override
    public void addRenderingHints(Map<?, ?> map) {
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }

    @Override
    public void draw(Shape shape) {
    }

    @Override
    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        return false;
    }

    @Override
    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int i, int i1) {
    }

    @Override
    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
    }

    @Override
    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
    }

    @Override
    public void drawString(String s, float v, float v1) {
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int i, int i1) {
    }

    @Override
    public boolean drawImage(Image image, int i, int i1, ImageObserver imageObserver) {
        return false;
    }

    @Override
    public boolean drawImage(Image image, int i, int i1, int i2, int i3, ImageObserver imageObserver) {
        return false;
    }

    @Override
    public boolean drawImage(Image image, int i, int i1, Color color, ImageObserver imageObserver) {
        return false;
    }

    @Override
    public boolean drawImage(Image image, int i, int i1, int i2, int i3, Color color, ImageObserver imageObserver) {
        return false;
    }

    @Override
    public boolean drawImage(Image image, int i, int i1, int i2, int i3, int i4, int i5, int i6, int i7, ImageObserver imageObserver) {
        return false;
    }

    @Override
    public boolean drawImage(Image image, int i, int i1, int i2, int i3, int i4, int i5, int i6, int i7, Color color, ImageObserver imageObserver) {
        return false;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float v, float v1) {
    }

    @Override
    public void drawGlyphVector(GlyphVector glyphVector, float v, float v1) {
    }

    @Override
    public void fill(Shape shape) {
    }

    @Override
    public boolean hit(Rectangle rectangle, Shape shape, boolean b) {
        return false;
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    @Override
    public void setComposite(Composite composite) {
    }

    @Override
    public void setPaint(Paint paint) {
    }

    @Override
    public AffineTransform getTransform() {
        return this.transform;
    }

    @Override
    public Paint getPaint() {
        return null;
    }

    @Override
    public Composite getComposite() {
        return null;
    }

    @Override
    public void setBackground(Color color) {
        this.background = color;
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    @Override
    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    public void clip(Shape shape) {
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.fontRenderContext;
    }
}

