/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui.panel;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Collection;
import java.util.List;
import org.igv.Globals;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.prefs.PreferencesManager;
import org.igv.sam.AlignmentTrack;
import org.igv.sam.InsertionMarker;
import org.igv.track.RenderContext;
import org.igv.track.Track;
import org.igv.track.TrackGroup;
import org.igv.ui.IGV;
import org.igv.ui.panel.ReferenceFrame;

public class DataPanelPainter {
    public static final Color GROUP_BORDER_COLOR = Globals.isDarkMode() ? Color.darkGray : Color.lightGray;
    public static final int TRACK_BORDER_HEIGHT = 3;
    private static Logger log = LogManager.getLogger(DataPanelPainter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void paint(Collection<TrackGroup> groups, RenderContext context, Color background, Rectangle visibleRect) {
        try {
            Graphics2D graphics2D = context.getGraphics2D("BACKGROUND");
            graphics2D.setBackground(background);
            graphics2D.clearRect(visibleRect.x, visibleRect.y, visibleRect.width, visibleRect.height);
            InsertionMarker insertion = context.getReferenceFrame().getExpandedInsertion();
            if (this.shouldPaintExpandedInsertion(insertion, context, visibleRect)) {
                this.paintWithExpandedInsertion(groups, context, visibleRect, insertion);
            } else {
                this.paintFrame(groups, context);
            }
            if (PreferencesManager.getPreferences().getAsBoolean("TRACK.DRAW_BORDERS")) {
                this.drawTrackBorders(groups, context);
            }
        }
        finally {
            context.dispose();
        }
    }

    private boolean shouldPaintExpandedInsertion(InsertionMarker insertion, RenderContext context, Rectangle visibleRect) {
        if (insertion == null) {
            return false;
        }
        List<AlignmentTrack> tracks = IGV.getInstance().getAlignmentTracks();
        if (tracks.isEmpty()) {
            return false;
        }
        ReferenceFrame frame = context.getReferenceFrame();
        int maxVizWindow = tracks.stream().mapToInt(Track::getVisibilityWindow).max().getAsInt();
        double frameExtent = frame.getEnd() - frame.getOrigin();
        if (frameExtent >= (double)maxVizWindow) {
            return false;
        }
        double scale = frame.getScale();
        int pixelPos = (int)(((double)insertion.position - frame.getOrigin()) / scale);
        int pixelWidth = (int)Math.ceil((double)insertion.size / scale);
        return pixelWidth > 1 && pixelPos < visibleRect.width && pixelPos + pixelWidth > 0;
    }

    private void paintWithExpandedInsertion(Collection<TrackGroup> groups, RenderContext context, Rectangle visibleRect, InsertionMarker insertion) {
        ReferenceFrame frame = context.getReferenceFrame();
        double scale = frame.getScale();
        int pixelPos = (int)(((double)insertion.position - frame.getOrigin()) / scale);
        int pixelWidth = (int)Math.ceil((double)insertion.size / scale);
        context.expandedInsertionPosition = insertion.position;
        if (pixelPos > 0) {
            this.paintFrame(groups, this.shiftRenderContext(context, context.getOrigin(), 0, pixelPos));
        }
        this.paintExpandedInsertion(insertion, groups, this.shiftRenderContext(context, insertion.position, pixelPos, pixelWidth));
        int rightStart = pixelPos + pixelWidth;
        int rightWidth = visibleRect.width - rightStart;
        if (rightWidth > 0) {
            RenderContext rightContext = this.shiftRenderContext(context, insertion.position, rightStart, rightWidth);
            rightContext.multiframe = true;
            this.paintFrame(groups, rightContext);
        }
    }

    private RenderContext shiftRenderContext(RenderContext ctx, double position, int translateX, int pixelWidth) {
        RenderContext newContext = new RenderContext(ctx);
        newContext.getReferenceFrame().widthInPixels = pixelWidth;
        newContext.getReferenceFrame().origin = position;
        newContext.visibleRect = new Rectangle(0, ctx.visibleRect.y, pixelWidth, ctx.visibleRect.height);
        newContext.translateX = translateX;
        Graphics2D dG = newContext.getGraphics();
        dG.translate(translateX, 0);
        dG.setClip(newContext.visibleRect);
        return newContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintFrame(Collection<TrackGroup> groups, RenderContext dContext) {
        int trackX = 0;
        int trackY = 0;
        Rectangle dRect = dContext.visibleRect;
        for (TrackGroup group : groups) {
            List<Track> trackList;
            if (dRect != null && trackY > dRect.y + dRect.height) break;
            if (!group.isVisible()) continue;
            if (groups.size() > 1) {
                Graphics2D greyGraphics = dContext.getGraphic2DForColor(GROUP_BORDER_COLOR);
                greyGraphics.fillRect(0, trackY + 1, dRect.width, 9);
                trackY += 10;
            }
            if (group.isDrawBorder()) {
                Graphics2D graphics2D = dContext.getGraphic2DForColor(GROUP_BORDER_COLOR);
                graphics2D.drawLine(0, trackY - 1, dRect.width, trackY - 1);
            }
            List<Track> list = trackList = group.getVisibleTracks();
            synchronized (list) {
                for (Track track : trackList) {
                    if (track == null) continue;
                    int trackHeight = track.getHeight();
                    if (dRect != null) {
                        if (trackY > dRect.y + dRect.height) break;
                        if (trackY + trackHeight < dRect.y) {
                            if (!track.isVisible()) continue;
                            trackY += trackHeight;
                            continue;
                        }
                    }
                    if (!track.isVisible()) continue;
                    Rectangle rect = new Rectangle(trackX, trackY, dRect.width, trackHeight);
                    Graphics2D g = dContext.getGraphics();
                    Shape originalClip = g.getClip();
                    dContext.clearGraphicsCache();
                    g.clip(rect);
                    try {
                        this.draw(track, rect, dContext);
                    }
                    catch (Exception e) {
                        log.error("Error rendering track: " + track.getName(), e);
                    }
                    finally {
                        g.setClip(originalClip);
                        dContext.clearGraphicsCache();
                    }
                    trackY += trackHeight + 3;
                }
            }
            if (!group.isDrawBorder()) continue;
            Graphics2D graphics2D = dContext.getGraphic2DForColor(GROUP_BORDER_COLOR);
            graphics2D.drawLine(0, trackY, dRect.width, trackY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void drawTrackBorders(Collection<TrackGroup> groups, RenderContext context) {
        int trackY = 0;
        Rectangle dRect = context.getVisibleRect();
        if (dRect == null) {
            return;
        }
        int bottom = dRect.y + dRect.height;
        Graphics2D borderGraphics = (Graphics2D)context.getGraphics().create();
        Color borderColor = PreferencesManager.getPreferences().getAsColor("TRACK.BORDER_COLOR");
        borderGraphics.setColor(borderColor);
        try {
            for (TrackGroup group : groups) {
                List<Track> trackList;
                if (!group.isVisible()) continue;
                List<Track> list = trackList = group.getVisibleTracks();
                synchronized (list) {
                    for (Track track : trackList) {
                        if (track == null || !track.isVisible()) continue;
                        int trackHeight = track.getHeight();
                        if (trackY > bottom) break;
                        if (trackY + trackHeight < dRect.y) {
                            trackY += trackHeight + 3;
                            continue;
                        }
                        int borderY = trackY + trackHeight + 1;
                        borderGraphics.drawLine(0, borderY, dRect.width, borderY);
                        trackY += trackHeight + 3;
                    }
                }
            }
            return;
        }
        finally {
            if (borderGraphics != null) {
                borderGraphics.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintExpandedInsertion(InsertionMarker insertionMarker, Collection<TrackGroup> groups, RenderContext context) {
        int trackY = 0;
        Rectangle dRect = context.getVisibleRect();
        for (TrackGroup group : groups) {
            List<Track> trackList;
            if (!group.isVisible()) continue;
            List<Track> list = trackList = group.getVisibleTracks();
            synchronized (list) {
                for (Track track : trackList) {
                    if (track == null) continue;
                    int trackHeight = track.getHeight();
                    if (dRect != null) {
                        if (trackY > dRect.y + dRect.height) break;
                        if (trackY + trackHeight < dRect.y) {
                            if (!track.isVisible()) continue;
                            trackY += trackHeight + 3;
                            continue;
                        }
                    }
                    if (track instanceof AlignmentTrack && track.isVisible()) {
                        Rectangle rect = new Rectangle(dRect.x, trackY, dRect.width, trackHeight);
                        ((AlignmentTrack)track).renderExpandedInsertion(insertionMarker, context, rect);
                    }
                    if (!track.isVisible()) continue;
                    trackY += trackHeight + 3;
                }
            }
        }
    }

    private void draw(Track track, Rectangle rect, RenderContext context) {
        track.render(context, rect);
        List<Track> overlayTracks = IGV.getInstance().getOverlayTracks(track);
        if (overlayTracks != null) {
            for (Track overlayTrack : overlayTracks) {
                if (overlayTrack == track) continue;
                overlayTrack.overlay(context, rect);
            }
        }
    }
}

