/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import org.igv.Globals;
import org.igv.feature.genome.GenomeManager;
import org.igv.feature.genome.load.HubGenomeLoader;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.session.SessionReader;
import org.igv.track.TrackGroup;
import org.igv.ui.FontManager;
import org.igv.ui.IGV;
import org.igv.ui.MessageCollection;
import org.igv.ui.panel.DataPanel;
import org.igv.ui.panel.FrameManager;
import org.igv.ui.panel.Paintable;
import org.igv.ui.panel.ReferenceFrame;
import org.igv.ui.panel.RegionOfInterestTool;
import org.igv.ui.panel.TrackPanel;
import org.igv.ui.panel.TrackPanelComponent;
import org.igv.ui.util.MessageUtils;
import org.igv.util.LongRunningTask;
import org.igv.util.ResourceLocator;

public class DataPanelContainer
extends TrackPanelComponent
implements Paintable {
    static final int default_hgap = 6;
    private static Logger log = LogManager.getLogger(DataPanelContainer.class);
    TrackPanel parent;

    public DataPanelContainer(TrackPanel trackPanel) {
        super(trackPanel);
        DropTarget target = new DropTarget(this, new FileDropTargetListener(this, trackPanel));
        this.setDropTarget(target);
        target.setActive(true);
        this.setLayout(new BoxLayout(this, 0));
        this.parent = trackPanel;
        this.createDataPanels();
    }

    public void createDataPanels() {
        this.removeAll();
        int hgap = 6;
        if (FrameManager.getFrames().size() > 10) {
            hgap = 1 + 20 / FrameManager.getFrames().size();
        }
        boolean first = true;
        for (ReferenceFrame f : FrameManager.getFrames()) {
            if (!f.isVisible()) continue;
            if (!first) {
                this.add(Box.createRigidArea(new Dimension(hgap, 0)));
            }
            DataPanel dp = new DataPanel(f, this);
            this.add(dp);
            first = false;
        }
        this.invalidate();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        for (Component c : this.getComponents()) {
            if (!(c instanceof DataPanel)) continue;
            c.setBackground(color);
        }
    }

    public Collection<TrackGroup> getTrackGroups() {
        TrackPanel dataTrackView = (TrackPanel)this.getParent();
        return dataTrackView.getGroups();
    }

    public int getVisibleHeight() {
        TrackPanel dataTrackView = (TrackPanel)this.getParent();
        return dataTrackView.getVisibleRect().height;
    }

    public void setCurrentTool(RegionOfInterestTool regionOfInterestTool) {
        for (Component c : this.getComponents()) {
            if (!(c instanceof DataPanel)) continue;
            ((DataPanel)c).setCurrentTool(regionOfInterestTool);
        }
    }

    @Override
    public void paintOffscreen(Graphics2D g, Rectangle rect, boolean batch) {
        Component[] components = this.getComponents();
        Arrays.sort(components, Comparator.comparingInt(Component::getX));
        for (Component c : this.getComponents()) {
            if (!(c instanceof DataPanel)) continue;
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.translate(c.getX(), 0);
            Rectangle panelRect = new Rectangle(0, rect.y, c.getWidth(), rect.height);
            ((DataPanel)c).paintOffscreen(g2d, panelRect, batch);
        }
    }

    @Override
    public int getSnapshotHeight(boolean batch) {
        return this.getHeight();
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (IGV.getInstance().isRulerEnabled()) {
            int start = MouseInfo.getPointerInfo().getLocation().x - this.getLocationOnScreen().x;
            g.setColor(Color.BLACK);
            g.drawLine(start, 0, start, this.getHeight());
            ReferenceFrame frame = FrameManager.getDefaultFrame();
            boolean allChrMode = frame.getChrName().equals("All");
            if (!FrameManager.isGeneListMode() && !allChrMode) {
                int y = MouseInfo.getPointerInfo().getLocation().y - this.getLocationOnScreen().y;
                int pos = (int)frame.getChromosomePosition(start) + 1;
                g.setFont(FontManager.getDefaultFont());
                g.drawString(Globals.DECIMAL_FORMAT.format((double)pos), start + 10, y + 30);
            }
        }
    }

    private class FileDropTargetListener
    implements DropTargetListener {
        private TrackPanel panel;

        public FileDropTargetListener(DataPanelContainer dataPanelContainer, TrackPanel dataPanel) {
            this.panel = dataPanel;
        }

        @Override
        public void dragEnter(DropTargetDragEvent event) {
            if (!this.isDragAcceptable(event)) {
                event.rejectDrag();
                return;
            }
        }

        @Override
        public void dragExit(DropTargetEvent event) {
        }

        @Override
        public void dragOver(DropTargetDragEvent event) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
            if (!this.isDragAcceptable(event)) {
                event.rejectDrag();
                return;
            }
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            IGV igv;
            MessageCollection messages;
            block15: {
                if (!this.isDropAcceptable(event)) {
                    event.rejectDrop();
                    return;
                }
                event.acceptDrop(1);
                Transferable transferable = event.getTransferable();
                DataFlavor[] flavors = transferable.getTransferDataFlavors();
                messages = new MessageCollection();
                igv = IGV.getInstance();
                try {
                    if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        List files = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                        if (files != null && files.size() > 0) {
                            if (files.size() == 1 && SessionReader.isSessionFile(((File)files.get(0)).getAbsolutePath())) {
                                String sessionPath = ((File)files.get(0)).getAbsolutePath();
                                LongRunningTask.submit(() -> igv.loadSession(sessionPath, null));
                            } else {
                                List<ResourceLocator> locators = ResourceLocator.getLocators(files);
                                igv.loadTracks(locators, this.panel);
                            }
                        }
                    } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        String obj = transferable.getTransferData(DataFlavor.stringFlavor).toString();
                        if (HubGenomeLoader.isHubURL(obj)) {
                            LongRunningTask.submit(() -> {
                                try {
                                    GenomeManager.getInstance().loadGenome(obj);
                                }
                                catch (IOException e) {
                                    MessageUtils.showMessage("Error loading track hub: " + e.getMessage());
                                }
                            });
                        } else if (SessionReader.isSessionFile(obj)) {
                            LongRunningTask.submit(() -> igv.loadSession(obj, null));
                        } else {
                            igv.loadTracks(Collections.singletonList(new ResourceLocator(obj)), this.panel);
                        }
                    } else {
                        messages.append("Unknown object type: " + transferable.toString());
                    }
                }
                catch (Exception e) {
                    log.error(e);
                    if (e.getMessage() == null) break block15;
                    messages.append(e.getMessage());
                }
            }
            if (messages != null && !messages.isEmpty()) {
                MessageUtils.showMessage(messages.getFormattedMessage());
            }
            igv.getMainFrame().repaint();
            event.dropComplete(true);
        }

        public boolean isDragAcceptable(DropTargetDragEvent event) {
            return (event.getDropAction() & 3) != 0;
        }

        public boolean isDropAcceptable(DropTargetDropEvent event) {
            return (event.getDropAction() & 3) != 0;
        }
    }
}

