/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui.commandbar;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.igv.feature.genome.Genome;
import org.igv.feature.genome.GenomeManager;
import org.igv.ui.panel.FrameManager;
import org.igv.ui.util.UIUtilities;

public class ChromosomeComboBox
extends JComboBox<String> {
    private static final int MAX_CHROMOSOME_COUNT = 10000;
    private static final String MAX_EXCEEDED = "Max exceeded";

    public ChromosomeComboBox() {
        this.addActionListener(this::chromosomeComboBoxActionPerformed);
    }

    private void chromosomeComboBoxActionPerformed(ActionEvent evt) {
        JComboBox combobox = (JComboBox)evt.getSource();
        String chrDisplayName = (String)combobox.getSelectedItem();
        String chrName = GenomeManager.getInstance().getCurrentGenome().getCanonicalChrName(chrDisplayName);
        if (chrName != null && !chrName.equals(FrameManager.getDefaultFrame().getChrName()) && !chrName.equals(MAX_EXCEEDED)) {
            FrameManager.getDefaultFrame().changeChromosome(chrName, true);
        }
    }

    public void updateChromosFromGenome(Genome genome) {
        if (genome == null) {
            return;
        }
        UIUtilities.invokeAndWaitOnEventThread(() -> {
            List<String> chromosomeNames = genome.getChromosomeNames();
            if (chromosomeNames == null) {
                this.setVisible(false);
            } else {
                List<String> allChromosomeNames = chromosomeNames.stream().map(genome::getChromosomeDisplayName).toList();
                if (allChromosomeNames.size() > 1) {
                    this.setVisible(true);
                    ArrayList<String> tmp = new ArrayList<String>(allChromosomeNames.size() > 10000 ? allChromosomeNames.subList(0, 10000) : allChromosomeNames);
                    String homeChr = genome.getHomeChromosome();
                    if (homeChr.equals("All")) {
                        tmp.addFirst("All");
                    }
                    if (allChromosomeNames.size() > 10000) {
                        tmp.add(MAX_EXCEEDED);
                    }
                    Graphics2D graphics2D = (Graphics2D)this.getGraphics();
                    Font font = this.getFont();
                    FontMetrics fontMetrics = this.getFontMetrics(font);
                    int w = 120;
                    for (String chromosomeName : tmp) {
                        int width;
                        Rectangle2D textBounds = fontMetrics.getStringBounds(chromosomeName, graphics2D);
                        if (textBounds == null || (width = textBounds.getBounds().width + 50) <= w) continue;
                        w = width;
                    }
                    DefaultComboBoxModel<String> defaultModel = new DefaultComboBoxModel<String>(tmp.toArray(new String[0]));
                    int dropdownWidth = w;
                    this.setModel(defaultModel);
                    this.setSelectedItem(genome.getHomeChromosome());
                    this.adjustChromosomeDropdownWidth(dropdownWidth);
                } else {
                    this.setVisible(false);
                }
            }
        });
    }

    private void adjustChromosomeDropdownWidth(int width) {
        int newWidth = Math.max(width, 120);
        this.setMaximumSize(new Dimension(newWidth, 35));
        this.setMinimumSize(new Dimension(newWidth, 27));
        this.setPreferredSize(new Dimension(newWidth, 16));
        this.revalidate();
    }
}

