/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui.color;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.igv.ui.color.ColorTable;
import org.igv.ui.color.ColorUtilities;

public class HSLColorTable
implements ColorTable {
    int hueCenter;
    boolean greyscale = false;
    Map<String, Color> colorMap = new HashMap<String, Color>();

    public HSLColorTable(int hueCenter) {
        this.hueCenter = hueCenter;
    }

    @Override
    public Color get(String key) {
        Color c = this.colorMap.get(key);
        if (c == null) {
            if (this.greyscale) {
                int r = (int)(50.0 + Math.random() * 155.0);
                c = new Color(r, r, r);
            } else {
                double hue = (double)(this.hueCenter - 30) + Math.random() * 60.0;
                double saturation = 0.4 + Math.random() * 0.6;
                double lightness = 0.2 + Math.random() * 0.4;
                int[] rgb = ColorUtilities.hslToRgb(hue, saturation, lightness);
                c = new Color(rgb[0], rgb[1], rgb[2]);
            }
            this.colorMap.put(key, c);
        }
        return c;
    }
}

