/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui.color;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import org.igv.ui.util.IGVMouseInputAdapter;

public class ColorChooserPanel
extends JPanel
implements Serializable {
    Color selectedColor;
    List<ActionListener> listeners = new ArrayList<ActionListener>();
    private JPanel colorPanel;
    private AbstractButton changeButton;

    public ColorChooserPanel() {
        this(Color.white);
    }

    public ColorChooserPanel(Color selectedColor) {
        this.selectedColor = selectedColor;
        this.initComponents();
        this.setSelectedColor(selectedColor);
    }

    public void setSelectedColor(Color selectedColor) {
        this.selectedColor = selectedColor;
        this.colorPanel.setBackground(selectedColor);
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    private void changeButtonActionPerformed(ActionEvent e) {
        this.changeColorAction();
    }

    private void colorPanelMouseClicked(MouseEvent e) {
        this.changeColorAction();
    }

    private void changeColorAction() {
        JColorChooser colorChooser = new JColorChooser(this.selectedColor);
        JDialog dialog = JColorChooser.createDialog(this, "Select color", true, colorChooser, null, null);
        dialog.setVisible(true);
        Color c = colorChooser.getColor();
        if (c != null) {
            this.setSelectedColor(c);
        }
        ActionEvent evt = new ActionEvent(this, 0, "");
        for (ActionListener l : this.listeners) {
            l.actionPerformed(evt);
        }
    }

    private void initComponents() {
        this.colorPanel = new JPanel();
        this.changeButton = new JButton();
        if (UIManager.getLookAndFeel().getName().toLowerCase().contains("metal")) {
            this.changeButton = new JMenuItem();
        }
        this.setLayout(new GridBagLayout());
        ((GridBagLayout)this.getLayout()).columnWidths = new int[]{30, 0, 0};
        ((GridBagLayout)this.getLayout()).rowHeights = new int[]{0, 0};
        ((GridBagLayout)this.getLayout()).columnWeights = new double[]{1.0, 1.0, 1.0E-4};
        ((GridBagLayout)this.getLayout()).rowWeights = new double[]{1.0, 1.0E-4};
        this.colorPanel.setPreferredSize(new Dimension(20, 15));
        this.colorPanel.setMinimumSize(new Dimension(20, 5));
        this.colorPanel.setMaximumSize(new Dimension(20, 15));
        this.colorPanel.setFocusable(false);
        this.colorPanel.setBorder(LineBorder.createBlackLineBorder());
        this.colorPanel.setBackground(new Color(204, 204, 255));
        this.colorPanel.setLayout(null);
        this.colorPanel.addMouseListener(new IGVMouseInputAdapter(){

            @Override
            public void igvMouseClicked(MouseEvent mouseEvent) {
                ColorChooserPanel.this.colorPanelMouseClicked(mouseEvent);
            }
        });
        this.add((Component)this.colorPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.changeButton.setHorizontalAlignment(2);
        this.changeButton.setIcon(UIManager.getIcon("Menu.arrowIcon"));
        this.changeButton.setToolTipText("Change color");
        this.changeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorChooserPanel.this.changeButtonActionPerformed(e);
            }
        });
        this.add((Component)this.changeButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }
}

