/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui.action;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JOptionPane;
import org.igv.DirectoryManager;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.prefs.PreferencesManager;
import org.igv.ui.IGV;
import org.igv.ui.WaitCursorManager;
import org.igv.ui.action.MenuAction;
import org.igv.ui.util.FileDialogUtils;

public class SaveSessionMenuAction
extends MenuAction {
    static Logger log = LogManager.getLogger(SaveSessionMenuAction.class);
    IGV igv;

    public SaveSessionMenuAction(String label, int mnemonic, IGV igv) {
        super(label, null, mnemonic);
        this.igv = igv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        File sessionFile = null;
        String currentSessionFilePath = this.igv.getSession().getPath();
        File parentDir = currentSessionFilePath == null ? null : new File(new File(currentSessionFilePath).getParent());
        String initFile = currentSessionFilePath == null || parentDir.equals(DirectoryManager.getAutosaveDirectory()) ? "igv_session.xml" : currentSessionFilePath;
        sessionFile = FileDialogUtils.chooseFile("Save Session", PreferencesManager.getPreferences().getLastTrackDirectory(), new File(initFile), FileDialogUtils.SAVE);
        if (sessionFile == null) {
            this.igv.resetStatusMessage();
            return;
        }
        String filePath = sessionFile.getAbsolutePath();
        if (!filePath.toLowerCase().endsWith(".xml")) {
            sessionFile = new File(filePath + ".xml");
        }
        this.igv.setStatusBarMessage("Saving session to " + sessionFile.getAbsolutePath());
        File sf = sessionFile;
        WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
        try {
            this.igv.saveSession(sf);
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(this.igv.getMainFrame(), "There was an error writing to " + sf.getName() + "(" + e2.getMessage() + ")");
            log.error("Failed to save session <br/>" + e2.getMessage(), e2);
        }
        finally {
            WaitCursorManager.removeWaitCursor(token);
            this.igv.resetStatusMessage();
        }
    }
}

