/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.igv.track.DataTrack;
import org.igv.track.MergedTracks;
import org.igv.track.Track;
import org.igv.ui.AttributeSelectionDialog;
import org.igv.ui.IGV;
import org.igv.ui.action.MenuAction;
import org.igv.ui.panel.TrackPanel;
import org.igv.ui.util.UIUtilities;

public class OverlayTracksMenuAction
extends MenuAction {
    IGV igv;

    public OverlayTracksMenuAction(String label, int mnemonic, IGV igv) {
        super(label, null, mnemonic);
        this.igv = igv;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        UIUtilities.invokeOnEventThread(() -> {
            AttributeSelectionDialog dlg = new AttributeSelectionDialog(this.igv.getMainFrame(), "Overlay");
            dlg.setVisible(true);
            if (!dlg.isCanceled()) {
                String selectedAttribute = dlg.getSelected();
                if (selectedAttribute == null) {
                    OverlayTracksMenuAction.unmerge(IGV.getInstance().getAllTracks());
                } else {
                    List<DataTrack> tracks = IGV.getInstance().getDataTracks();
                    HashMap<String, ArrayList<DataTrack>> groups = new HashMap<String, ArrayList<DataTrack>>();
                    for (DataTrack dataTrack : tracks) {
                        String v = dataTrack.getAttributeValue(selectedAttribute);
                        if (v == null) continue;
                        ArrayList<DataTrack> tlist = (ArrayList<DataTrack>)groups.get(v);
                        if (tlist == null) {
                            tlist = new ArrayList<DataTrack>();
                            groups.put(v, tlist);
                        }
                        tlist.add(dataTrack);
                    }
                    for (Map.Entry entry : groups.entrySet()) {
                        String name = (String)entry.getKey();
                        OverlayTracksMenuAction.merge((List)entry.getValue(), name);
                    }
                    this.igv.repaint();
                }
            }
        });
    }

    public static void merge(List<DataTrack> dataTrackList, String name) {
        MergedTracks mergedTracks = new MergedTracks(UUID.randomUUID().toString(), name, dataTrackList);
        Track firstTrack = dataTrackList.iterator().next();
        TrackPanel panel = TrackPanel.getParentPanel(firstTrack);
        panel.addTrack(mergedTracks);
        panel.moveSelectedTracksTo(Arrays.asList(mergedTracks), firstTrack, false);
        panel.removeTracks(dataTrackList);
    }

    public static void unmerge(Collection<Track> tracks) {
        for (Track t : tracks) {
            if (!(t instanceof MergedTracks)) continue;
            TrackPanel panel = TrackPanel.getParentPanel(t);
            MergedTracks mergedTracks = (MergedTracks)t;
            mergedTracks.setTrackAlphas(1.0);
            panel.addTracks(mergedTracks.getMemberTracks());
            panel.moveSelectedTracksTo(mergedTracks.getMemberTracks(), mergedTracks, true);
            IGV.getInstance().deleteTracks(Arrays.asList(mergedTracks));
        }
        IGV.getInstance().repaint();
    }
}

