/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui.action;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.PrintWriter;
import java.util.Collection;
import org.igv.DirectoryManager;
import org.igv.feature.RegionOfInterest;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.prefs.PreferencesManager;
import org.igv.ui.IGV;
import org.igv.ui.action.MenuAction;
import org.igv.ui.panel.RegionNavigatorDialog;
import org.igv.ui.util.FileDialogUtils;
import org.igv.ui.util.UIUtilities;

public class ExportRegionsMenuAction
extends MenuAction {
    static Logger log = LogManager.getLogger(ExportRegionsMenuAction.class);
    IGV mainFrame;

    public ExportRegionsMenuAction(String label, int mnemonic, IGV mainFrame) {
        super(label, null, mnemonic);
        this.mainFrame = mainFrame;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        UIUtilities.invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                ExportRegionsMenuAction.this.exportRegionsOfInterest();
            }
        });
    }

    public final void exportRegionsOfInterest() {
        String title;
        File file;
        File exportRegionDirectory;
        RegionNavigatorDialog navDialog = RegionNavigatorDialog.getInstance();
        if (navDialog != null) {
            navDialog.updateROIsFromRegionTable();
        }
        if ((exportRegionDirectory = PreferencesManager.getPreferences().getLastExportedRegionDirectory()) == null) {
            exportRegionDirectory = DirectoryManager.getUserDefaultDirectory();
        }
        if ((file = FileDialogUtils.chooseFile(title = "Export Regions of Interest ...", exportRegionDirectory, new File("regions.bed"), 1)) == null) {
            return;
        }
        this.writeRegionsOfInterestFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRegionsOfInterestFile(File roiFile) {
        if (roiFile == null) {
            return;
        }
        try {
            Collection<RegionOfInterest> regions = IGV.getInstance().getSession().getAllRegionsOfInterest();
            if (regions == null || regions.isEmpty()) {
                return;
            }
            roiFile.createNewFile();
            try (PrintWriter writer = null;){
                writer = new PrintWriter(roiFile);
                for (RegionOfInterest regionOfInterest : regions) {
                    Integer regionStart = regionOfInterest.getStart();
                    if (regionStart == null) continue;
                    Integer regionEnd = regionOfInterest.getEnd();
                    if (regionEnd == null) {
                        regionEnd = regionStart;
                    }
                    writer.print(regionOfInterest.getChr());
                    writer.print("\t");
                    writer.print(regionStart);
                    writer.print("\t");
                    writer.print(regionEnd);
                    if (regionOfInterest.getDescription() != null) {
                        writer.print("\t");
                        writer.println(regionOfInterest.getDescription());
                        continue;
                    }
                    writer.println();
                }
            }
        }
        catch (Exception e) {
            log.error("Failed to write Region of Interest export file!", e);
        }
    }
}

