/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.SequencedCollection;
import java.util.Set;

public class StackSet<T>
extends AbstractCollection<T>
implements Set<T>,
SequencedCollection<T> {
    private final LinkedList<T> values;
    final int maxSize;

    public StackSet(int maxSize) {
        this(new LinkedList(), maxSize);
    }

    public StackSet(Collection<T> initialValues, int maxSize) {
        this(new LinkedList(), maxSize);
        LinkedHashSet<T> unique = new LinkedHashSet<T>(initialValues);
        List limited = unique.stream().limit(maxSize).toList();
        this.values.addAll(limited);
    }

    private StackSet(LinkedList<T> values, int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize must be > 0");
        }
        this.maxSize = maxSize;
        this.values = values;
    }

    @Override
    public boolean add(T t) {
        this.values.remove(t);
        if (this.values.size() >= this.maxSize) {
            this.values.removeLast();
        }
        this.values.addFirst(t);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        ArrayList<T> list = new ArrayList<T>(c);
        list.reversed().forEach(this::add);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        return this.values.remove(o);
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public Iterator<T> iterator() {
        return this.values.iterator();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public StackSet<T> reversed() {
        return new StackSet<T>(this.values.reversed(), this.maxSize);
    }
}

