/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Pattern;
import org.igv.util.FileUtils;

public class ReadmeParser {
    private static final String DEFAULT_README_PATH = "/docs/igvtools_readme.txt";
    public static final String END_STR = "See http://www.broadinstitute.org/software/igv/igvtools_commandline, or igvtools_readme.txt, for more help" + FileUtils.LINE_SEPARATOR;
    private String path = "/docs/igvtools_readme.txt";

    public ReadmeParser() {
    }

    public ReadmeParser(String path) {
        this.path = path;
    }

    Pattern getCmdPattern(String command) {
        return Pattern.compile("command.{1,4}\"" + command, 2);
    }

    Pattern getStartEndPattern() {
        return Pattern.compile("[-,=,_]{8}");
    }

    BufferedReader getReader() throws FileNotFoundException {
        InputStream is = ReadmeParser.class.getResourceAsStream(this.path);
        if (is != null) {
            return new BufferedReader(new InputStreamReader(is));
        }
        return new BufferedReader(new FileReader(this.path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDocForCommand(String cmd) {
        Object out = "Command " + cmd + " not found" + FileUtils.LINE_SEPARATOR;
        BufferedReader reader = null;
        try {
            reader = this.getReader();
            String line = null;
            Pattern cmdPattern = this.getCmdPattern(cmd);
            Pattern stEndPattern = this.getStartEndPattern();
            int startEndLinesRem = -1;
            while ((line = reader.readLine()) != null) {
                if (startEndLinesRem < 0 && cmdPattern.matcher(line).find()) {
                    startEndLinesRem = 2;
                    out = "";
                } else if (startEndLinesRem < 0) continue;
                if (stEndPattern.matcher(line).find()) {
                    --startEndLinesRem;
                }
                if (startEndLinesRem >= 0) {
                    out = (String)out + line + FileUtils.LINE_SEPARATOR;
                }
                if (startEndLinesRem != 0) continue;
                break;
            }
        }
        catch (FileNotFoundException e) {
            out = "Could not find readme file " + this.path + FileUtils.LINE_SEPARATOR;
        }
        catch (IOException e) {
            out = "Error reading readme file " + this.path + FileUtils.LINE_SEPARATOR;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        out = (String)out + END_STR;
        return out;
    }
}

