/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicBorders;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.ui.IGV;
import org.igv.ui.UIConstants;
import org.igv.ui.commandbar.IGVCommandBar;
import org.igv.ui.panel.MainPanel;
import org.igv.ui.util.ApplicationStatusBar;

public class IGVContentPane
extends JPanel {
    private static Logger log = LogManager.getLogger(IGVContentPane.class);
    private JPanel commandBarPanel;
    private IGVCommandBar igvCommandBar;
    private MainPanel mainPanel;
    private ApplicationStatusBar statusBar;
    private IGV igv;

    public IGVContentPane(IGV igv) {
        this.setOpaque(true);
        this.igv = igv;
        this.setLayout(new BorderLayout());
        this.commandBarPanel = new JPanel();
        BoxLayout layout = new BoxLayout(this.commandBarPanel, 3);
        this.commandBarPanel.setLayout(layout);
        this.add((Component)this.commandBarPanel, "North");
        this.igvCommandBar = new IGVCommandBar();
        this.igvCommandBar.setMinimumSize(new Dimension(250, 33));
        this.igvCommandBar.setBorder(new BasicBorders.MenuBarBorder(Color.GRAY, Color.GRAY));
        this.igvCommandBar.setAlignmentX(1.0f);
        this.commandBarPanel.add(this.igvCommandBar);
        this.mainPanel = new MainPanel(igv);
        this.add((Component)this.mainPanel, "Center");
        this.statusBar = new ApplicationStatusBar();
        this.statusBar.setDebugGraphicsOptions(-1);
        this.add((Component)this.statusBar, "South");
    }

    @Override
    public Dimension getPreferredSize() {
        return UIConstants.preferredSize;
    }

    public void resetStatusMessage() {
        this.statusBar.setMessage(this.igv.getVisibleTrackCount() + " tracks loaded");
    }

    public MainPanel getMainPanel() {
        return this.mainPanel;
    }

    public IGVCommandBar getCommandBar() {
        return this.igvCommandBar;
    }

    public ApplicationStatusBar getStatusBar() {
        return this.statusBar;
    }
}

