/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.igv.ui.TrackFilterDialog;
import org.igv.util.FilterElement;

class FilterComponent
extends JPanel {
    private TrackFilterDialog filterDialog;
    private JComboBox comparisonOperatorComboBox;
    private JComboBox itemComboBox;
    private JButton removeButton;
    private JTextField valueTextField;

    public FilterComponent(TrackFilterDialog filterDialog, List<String> items, FilterElement element) {
        this.initComponents();
        this.filterDialog = filterDialog;
        this.itemComboBox.setModel(new DefaultComboBoxModel<Object>(items.toArray()));
        ArrayList<String> textForOperators = new ArrayList<String>();
        FilterElement.Operator[] operators = FilterElement.Operator.values();
        for (int i = 0; i < operators.length; ++i) {
            if (operators[i].equals(FilterElement.Operator.GREATER_THAN_OR_EQUAL) || operators[i].equals(FilterElement.Operator.LESS_THAN_OR_EQUAL)) continue;
            textForOperators.add(operators[i].getValue());
        }
        Collections.sort(textForOperators);
        this.comparisonOperatorComboBox.setModel(new DefaultComboBoxModel<Object>(textForOperators.toArray()));
        if (element != null) {
            this.itemComboBox.setSelectedItem(element.getAttributeKey());
            this.comparisonOperatorComboBox.setSelectedItem(element.getComparisonOperator().getValue());
            this.valueTextField.setText(element.getValue());
        }
    }

    private FilterElement.Operator getOperatorForText(String operatorText) {
        FilterElement.Operator[] operators;
        FilterElement.Operator selected = null;
        for (FilterElement.Operator operator : operators = FilterElement.Operator.values()) {
            if (!operatorText.equals(operator.getValue())) continue;
            selected = operator;
            break;
        }
        return selected;
    }

    public FilterElement getFilterElement(boolean matchAll) {
        String attributeKey = this.itemComboBox.getSelectedItem().toString();
        FilterElement.Operator operator = this.getOperatorForText((String)this.comparisonOperatorComboBox.getSelectedItem());
        String expectedValue = this.valueTextField.getText();
        return new FilterElement(attributeKey, operator, expectedValue);
    }

    public boolean isComplete() {
        return this.valueTextField.getText() != null && !this.valueTextField.getText().isEmpty();
    }

    protected void remove() {
        this.filterDialog.removeComponent(this);
    }

    private void initComponents() {
        this.setRequestFocusEnabled(false);
        this.setLayout(new FlowLayout(0, 2, 0));
        this.itemComboBox = new JComboBox();
        this.itemComboBox.setMinimumSize(new Dimension(50, 27));
        this.itemComboBox.setPreferredSize(new Dimension(150, 27));
        this.comparisonOperatorComboBox = new JComboBox();
        this.comparisonOperatorComboBox.setActionCommand("comparisonOperatorComboBoxChanged");
        this.comparisonOperatorComboBox.setMinimumSize(new Dimension(50, 27));
        this.comparisonOperatorComboBox.setPreferredSize(new Dimension(150, 27));
        this.valueTextField = new JTextField();
        this.valueTextField.setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
        this.valueTextField.setMinimumSize(new Dimension(50, 27));
        this.valueTextField.setPreferredSize(new Dimension(150, 27));
        this.add(this.itemComboBox);
        this.add(this.comparisonOperatorComboBox);
        this.add(this.valueTextField);
        this.removeButton = new JButton("-");
        this.removeButton.setFont(new Font("Arial", 0, 14));
        this.removeButton.setContentAreaFilled(false);
        this.removeButton.setHorizontalTextPosition(0);
        this.removeButton.setPreferredSize(new Dimension(45, 27));
        this.removeButton.addActionListener(evt -> this.remove());
        this.add(this.removeButton);
    }
}

