/*
 * Decompiled with CFR 0.152.
 */
package org.igv.track;

import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Map;
import org.igv.feature.genome.load.TrackConfig;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.track.Track;
import org.igv.track.WindowFunction;
import org.igv.ui.color.ColorUtilities;
import org.igv.util.ParsingUtils;
import org.igv.util.StringUtils;

public class TrackProperties {
    private static Logger log = LogManager.getLogger(TrackProperties.class);
    private String trackLine;
    private Track.DisplayMode displayMode;
    private BaseCoord baseCoord = BaseCoord.UNSPECIFIED;
    private String type;
    private String name;
    private String description;
    private String url;
    private Integer height;
    private Integer minHeight;
    private boolean gffTags = false;
    private Color color;
    private Color altColor;
    private Color midColor;
    private String genome;
    private Boolean autoscale;
    private Float minValue;
    private Float maxValue;
    private Float midValue;
    private Float neutralFromValue;
    private Float neutralToValue;
    private boolean drawYLine = false;
    private Class rendererClass;
    private WindowFunction windowingFunction;
    private int smoothingWindow;
    private Boolean itemRGB = null;
    private Boolean useScore = null;
    private int featureVisibilityWindow = -1;
    private boolean logScale = false;
    private Float yLine;
    private boolean sortable = true;
    private boolean alternateExonColor = false;
    private String dataURL;
    private String indexURL;
    private String coverageURL;
    private String format;
    private Map<String, String> attributes;

    public TrackProperties() {
    }

    public TrackProperties(TrackConfig trackConfig) {
        if (trackConfig.color != null) {
            this.color = this.parseColor(trackConfig.color);
        }
        if (trackConfig.altColor != null) {
            this.altColor = this.parseColor(trackConfig.altColor);
        }
        if (trackConfig.displayMode != null) {
            this.displayMode = this.parseDisplayMode(trackConfig.displayMode);
        }
        this.setFeatureVisibilityWindow(trackConfig.visibilityWindow != null ? trackConfig.visibilityWindow : -1);
        if (trackConfig.min != null) {
            this.setMinValue(trackConfig.min.floatValue());
        }
        if (trackConfig.max != null) {
            this.setMaxValue(trackConfig.max);
        }
        if (trackConfig.autoscale != null) {
            this.setAutoScale(trackConfig.autoscale);
        }
        if (trackConfig.height != null) {
            this.setHeight(trackConfig.height);
        }
        if (trackConfig.minHeight != null) {
            this.setMinHeight(trackConfig.minHeight);
        }
    }

    private Color parseColor(String color) {
        if (color != null) {
            try {
                return ColorUtilities.stringToColor(color);
            }
            catch (Exception e) {
                log.error("Error parsing color string: " + color, e);
            }
        }
        return null;
    }

    private Track.DisplayMode parseDisplayMode(String displayMode) {
        if (displayMode != null) {
            try {
                return Track.DisplayMode.valueOf(StringUtils.stripQuotes(displayMode));
            }
            catch (Exception e) {
                log.error("Error parsing displayMode " + displayMode, e);
            }
        }
        return null;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setTrackLine(String trackLine) {
        this.trackLine = trackLine;
    }

    public String getTrackLine() {
        return this.trackLine;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    public boolean isLogScale() {
        return this.logScale;
    }

    public void setLogScale(boolean logScale) {
        this.logScale = logScale;
    }

    public int getFeatureVisibilityWindow() {
        return this.featureVisibilityWindow;
    }

    public void setFeatureVisibilityWindow(int featureVisibilityWindow) {
        this.featureVisibilityWindow = featureVisibilityWindow;
    }

    public Boolean isUseScore() {
        return this.useScore;
    }

    public void setUseScore(Boolean useScore) {
        this.useScore = useScore;
    }

    public Boolean isItemRGB() {
        return this.itemRGB;
    }

    public void setItemRGB(Boolean itemRGB) {
        this.itemRGB = itemRGB;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getAltColor() {
        return this.altColor;
    }

    public void setAltColor(Color altColor) {
        this.altColor = altColor;
    }

    public String getGenome() {
        return this.genome;
    }

    public void setGenome(String genome) {
        this.genome = genome;
    }

    public Boolean getAutoScale() {
        return this.autoscale;
    }

    public void setAutoScale(Boolean autoScale) {
        this.autoscale = autoScale;
    }

    public Float getMinValue() {
        return this.minValue;
    }

    public void setMinValue(float minValue) {
        this.minValue = Float.valueOf(minValue);
    }

    public Float getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Float maxValue) {
        this.maxValue = maxValue;
    }

    public Float getMidValue() {
        return this.midValue;
    }

    public void setMidValue(Float midValue) {
        this.midValue = midValue;
    }

    public WindowFunction getWindowingFunction() {
        return this.windowingFunction;
    }

    public void setWindowingFunction(WindowFunction windowingFunction) {
        this.windowingFunction = windowingFunction;
    }

    public int getSmoothingWindow() {
        return this.smoothingWindow;
    }

    public void setSmoothingWindow(int smoothingWindow) {
        this.smoothingWindow = smoothingWindow;
    }

    public Class getRendererClass() {
        return this.rendererClass;
    }

    public void setRendererClass(Class rendererClass) {
        this.rendererClass = rendererClass;
    }

    public Color getMidColor() {
        return this.midColor;
    }

    public void setMidColor(Color midColor) {
        this.midColor = midColor;
    }

    public boolean isDrawYLine() {
        return this.drawYLine;
    }

    public void setDrawYLine(boolean drawYLine) {
        this.drawYLine = drawYLine;
    }

    public Integer getMinHeight() {
        return this.minHeight;
    }

    public void setMinHeight(Integer minHeight) {
        this.minHeight = minHeight;
    }

    public BaseCoord getBaseCoord() {
        return this.baseCoord;
    }

    public void setBaseCoord(BaseCoord baseCoord) {
        this.baseCoord = baseCoord;
    }

    public Float getNeutralFromValue() {
        return this.neutralFromValue;
    }

    public void setNeutralFromValue(Float neutralFromValue) {
        this.neutralFromValue = neutralFromValue;
    }

    public Float getNeutralToValue() {
        return this.neutralToValue;
    }

    public void setNeutralToValue(Float neutralToValue) {
        this.neutralToValue = neutralToValue;
    }

    public Float getyLine() {
        return this.yLine;
    }

    public void setyLine(Float yLine) {
        this.yLine = yLine;
    }

    public void setGffTags(boolean gffTags) {
        this.gffTags = gffTags;
    }

    public boolean isGffTags() {
        return this.gffTags;
    }

    public boolean isAlternateExonColor() {
        return this.alternateExonColor;
    }

    public void setAlternateExonColor(boolean alternateExonColor) {
        this.alternateExonColor = alternateExonColor;
    }

    public void setDisplayMode(Track.DisplayMode displayMode) {
        this.displayMode = displayMode;
    }

    public Track.DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public String getDataURL() {
        return this.dataURL;
    }

    public String getIndexURL() {
        return this.indexURL;
    }

    public String getCoverageURL() {
        return this.coverageURL;
    }

    public void setDataURL(String dataURL) {
        this.dataURL = dataURL;
    }

    public void setIndexURL(String indexURL) {
        this.indexURL = indexURL;
    }

    public void setCoverageURL(String coverageURL) {
        this.coverageURL = coverageURL;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setMetaData(String value) {
        String[] attStrings;
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap<String, String>();
        }
        for (String att : attStrings = ParsingUtils.SEMI_COLON_PATTERN.split(value)) {
            String[] kv = ParsingUtils.EQ_PATTERN.split(att, 2);
            if (kv.length == 2) {
                this.attributes.put(kv[0], kv[1]);
                continue;
            }
            log.warn("Skipping meta value: " + value + ".  Missing '=' token?");
        }
    }

    public static enum BaseCoord {
        ZERO,
        ONE,
        UNSPECIFIED;

    }
}

