/*
 * Decompiled with CFR 0.152.
 */
package org.igv.track;

import htsjdk.tribble.Feature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.igv.feature.genome.Genome;
import org.igv.feature.genome.GenomeManager;
import org.igv.track.FeatureSource;

class FeatureTrackUtils {
    static int MIN_BUFFER_SIZE = 10000;

    FeatureTrackUtils() {
    }

    public static Feature nextFeature(FeatureSource source, String chr, int initStart, int initEnd, double position, int buffer, boolean forward) throws IOException {
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        int binSize = Math.max(MIN_BUFFER_SIZE, buffer);
        if (forward) {
            int nextStart = initEnd;
            String nextChr = chr;
            while (nextChr != null) {
                int chrLength = genome.getChromosome(nextChr).getLength();
                while (nextStart < chrLength) {
                    int nextEnd = binSize > 0 ? nextStart + binSize : chrLength;
                    Iterator iter = source.getFeatures(nextChr, nextStart, nextEnd);
                    if (iter != null) {
                        while (iter.hasNext()) {
                            Feature feat = (Feature)iter.next();
                            if (!(FeatureTrackUtils.center(feat) > position)) continue;
                            return feat;
                        }
                    }
                    nextStart = nextEnd;
                }
                nextChr = genome.getNextChrName(nextChr);
                nextStart = 0;
                position = -1.0;
            }
        } else {
            int nextEnd = initStart;
            String nextChr = chr;
            while (nextChr != null) {
                while (nextEnd > 0) {
                    int nextStart = binSize > 0 ? Math.max(0, nextEnd - binSize) : 0;
                    Iterator iter = source.getFeatures(nextChr, nextStart, nextEnd);
                    ArrayList<Feature> featureList = new ArrayList<Feature>();
                    if (iter != null && iter.hasNext()) {
                        featureList.add((Feature)iter.next());
                    }
                    int idx = featureList.size();
                    while (--idx >= 0) {
                        if (!(FeatureTrackUtils.center((Feature)featureList.get(idx)) < position)) continue;
                        return (Feature)featureList.get(idx);
                    }
                    nextEnd = nextStart;
                }
                if ((nextChr = genome.getPrevChrName(nextChr)) == null) continue;
                nextEnd = genome.getChromosome(nextChr).getLength();
                position = 2.147483647E9;
            }
        }
        return null;
    }

    private static double center(Feature f) {
        return (double)(f.getStart() + f.getEnd()) / 2.0;
    }
}

