/*
 * Decompiled with CFR 0.152.
 */
package org.igv.tools.sort;

import htsjdk.tribble.readers.AsciiLineReader;
import java.io.IOException;
import org.igv.Globals;
import org.igv.tools.sort.SortableRecord;

public class Parser {
    private int chrCol;
    private int startCol;
    boolean splitOnWhiteSpace;
    private String commentPrefix;

    public Parser(int chrCol, int startCol) {
        this(chrCol, startCol, false, "#");
    }

    public Parser(int chrCol, int startCol, boolean splitOnWhiteSpace) {
        this(chrCol, startCol, splitOnWhiteSpace, "#");
    }

    public Parser(int chrCol, int startCol, boolean splitOnWhitespace, String commentPrefix) {
        this.chrCol = chrCol;
        this.startCol = startCol;
        this.splitOnWhiteSpace = splitOnWhitespace;
        this.commentPrefix = commentPrefix;
    }

    public SortableRecord readNextRecord(AsciiLineReader reader) {
        String nextLine = null;
        try {
            nextLine = reader.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        if (nextLine == null) {
            return null;
        }
        if (nextLine.trim().length() == 0 || nextLine.startsWith(this.commentPrefix)) {
            return this.readNextRecord(reader);
        }
        try {
            return this.createRecord(nextLine);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            System.out.println(nextLine);
            throw e;
        }
    }

    public SortableRecord createRecord(String nextLine) {
        int start;
        String[] fields = this.splitOnWhiteSpace ? Globals.singleTabMultiSpacePattern.split(nextLine) : Globals.tabPattern.split(nextLine, -1);
        String chr = fields[this.chrCol];
        try {
            start = Integer.parseInt(fields[this.startCol].trim());
        }
        catch (NumberFormatException e) {
            start = Integer.MAX_VALUE;
        }
        String text = nextLine;
        return new SortableRecord(chr, start, text);
    }
}

