/*
 * Decompiled with CFR 0.152.
 */
package org.igv.tools.parsers;

import java.util.Hashtable;
import org.igv.tools.parsers.DataConsumer;
import org.igv.track.TrackType;

public abstract class AbstractParser {
    private static Hashtable<String, String> chromosomeNames = new Hashtable();
    private DataConsumer dataConsumer;
    String trackLine = null;
    private TrackType trackType = TrackType.COPY_NUMBER;
    private String[] headings;

    public AbstractParser(DataConsumer dataConsumer) {
        this.dataConsumer = dataConsumer;
    }

    public DataConsumer getDataConsumer() {
        return this.dataConsumer;
    }

    protected void setTrackParameters() {
        this.dataConsumer.setTrackParameters(this.trackType, this.trackLine, this.headings);
    }

    void parseComment(String comment) {
        String tmp = comment.substring(1, comment.length());
        if (tmp.startsWith("track")) {
            this.trackLine = tmp;
        } else {
            String[] tokens = tmp.split("=");
            if (tokens.length != 2) {
                return;
            }
            String key = tokens[0].trim().toLowerCase();
            if (key.equals("type")) {
                try {
                    this.setTrackType(TrackType.valueOf(tokens[1].trim().toUpperCase()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void setHeadings(String[] headings) {
        this.headings = headings;
    }

    public String[] getHeadings() {
        return this.headings;
    }

    public TrackType getTrackType() {
        return this.trackType;
    }

    public void setTrackType(TrackType trackType) {
        this.trackType = trackType;
    }
}

