/*
 * Decompiled with CFR 0.152.
 */
package org.igv.tools.motiffinder;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import org.igv.feature.Strand;
import org.igv.tools.motiffinder.MotifFinderDialog;
import org.igv.track.MotifTrack;
import org.igv.track.Track;
import org.igv.ui.IGV;
import org.igv.util.StringUtils;

public class MotifFinderPlugin {
    public static JMenuItem getMenuItem() {
        JMenuItem menuItem = new JMenuItem("Find Motif...");
        menuItem.addActionListener(e -> {
            MotifFinderDialog dialog = new MotifFinderDialog(IGV.getInstance().getMainFrame());
            dialog.setVisible(true);
            MotifFinderPlugin.handleDialogResult(dialog);
        });
        return menuItem;
    }

    static void handleDialogResult(MotifFinderDialog dialog) {
        String[] pattern = dialog.getInputPattern();
        if (pattern != null) {
            String[] posTrackName = dialog.getPosTrackName();
            String[] negTrackName = dialog.getNegTrackName();
            MotifFinderPlugin.addTracksForPatterns(pattern, posTrackName, negTrackName);
        }
    }

    static List<Track> addTracksForPatterns(String[] pattern, String[] posTrackNames, String[] negTrackNames) {
        List<Track> trackList = MotifFinderPlugin.generateTracksForPatterns(pattern, posTrackNames, negTrackNames);
        IGV.getInstance().addTracks(trackList);
        return trackList;
    }

    static List<Track> generateTracksForPatterns(String[] patterns, String[] posTrackNames, String[] negTrackNames) {
        Color[] colors = new Color[]{null, Color.RED};
        Strand[] strands = new Strand[]{Strand.POSITIVE, Strand.NEGATIVE};
        ArrayList<Track> trackList = new ArrayList<Track>(2 * posTrackNames.length);
        if (patterns != null) {
            for (int pi = 0; pi < patterns.length; ++pi) {
                String pattern = patterns[pi];
                String[] curTrackNames = new String[]{posTrackNames[pi], negTrackNames[pi]};
                for (int ci = 0; ci < curTrackNames.length; ++ci) {
                    String tName = curTrackNames[ci];
                    if (tName == null) continue;
                    MotifTrack track = new MotifTrack(tName, pattern, strands[ci]);
                    if (colors[ci] != null) {
                        track.setColor(colors[ci]);
                    }
                    track.setDisplayMode(Track.DisplayMode.SQUISHED);
                    trackList.add(track);
                }
            }
        }
        return trackList;
    }

    public String run(List<String> args) {
        String cmd = args.get(0);
        if (cmd.equalsIgnoreCase("find")) {
            String pattern = args.get(1);
            String[] patterns = new String[]{pattern};
            String shrtPattern = StringUtils.checkLength(pattern, 100);
            String[] posName = new String[]{shrtPattern + " Positive"};
            String[] negName = new String[]{shrtPattern + " Negative"};
            MotifFinderPlugin.addTracksForPatterns(patterns, posName, negName);
            return "OK";
        }
        return "ERROR: Unknown command " + cmd + " for plugin " + this.getClass().getName();
    }
}

