/*
 * Decompiled with CFR 0.152.
 */
package org.igv.tools.experimental;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import org.igv.sam.cram.IGVReferenceSource;
import org.igv.util.HttpUtils;

public class ExtractPairs {
    private static final int READ_PAIRED_FLAG = 1;
    private static final int PROPER_PAIR_FLAG = 2;
    private static final int READ_UNMAPPED_FLAG = 4;
    private static final int MATE_UNMAPPED_FLAG = 8;
    private static final int READ_STRAND_FLAG = 16;
    protected static final int MATE_STRAND_FLAG = 32;
    private static final int FIRST_OF_PAIR_FLAG = 64;
    private static final int SECOND_OF_PAIR_FLAG = 128;
    private static final int NOT_PRIMARY_ALIGNMENT_FLAG = 256;
    private static final int READ_FAILS_VENDOR_QUALITY_CHECK_FLAG = 512;
    private static final int DUPLICATE_READ_FLAG = 1024;
    private static final int SUPPLEMENTARY_ALIGNMENT_FLAG = 2048;

    public static void main(String[] args) throws IOException {
        String inputFile = "/Volumes/GoogleDrive/Shared drives/IGV/MB275/MB275.discordant.namesorted.bam";
        String outputFile = "/Volumes/GoogleDrive/Shared drives/IGV/MB275/pairs2.txt";
        ExtractPairs.extract(inputFile, outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void extract(String alignmentFile, String outputFile) throws IOException {
        SamReader reader = null;
        SAMRecordIterator iter = null;
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            reader = ExtractPairs.getSamReader(alignmentFile);
            iter = reader.iterator();
            SAMRecord lastAlignment = null;
            while (iter != null && iter.hasNext()) {
                SAMRecord alignment = (SAMRecord)iter.next();
                if (!ExtractPairs.filter(alignment)) continue;
                if (lastAlignment == null || !alignment.getReadName().equals(lastAlignment.getReadName())) {
                    lastAlignment = alignment;
                    continue;
                }
                if (!lastAlignment.getContig().equals(alignment.getContig()) || Math.abs(lastAlignment.getStart() - alignment.getStart()) > 1000) {
                    SAMRecord first = lastAlignment.getContig().compareTo(alignment.getContig()) < 0 ? lastAlignment : alignment;
                    SAMRecord second = lastAlignment.getContig().compareTo(alignment.getContig()) < 0 ? alignment : lastAlignment;
                    pw.println(ExtractPairs.posString(first) + "\t0\t" + ExtractPairs.posString(second) + "\t0");
                }
                lastAlignment = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            pw.flush();
            pw.close();
            iter.close();
            reader.close();
        }
    }

    static boolean filter(SAMRecord alignment) {
        return alignment.getMappingQuality() > 0;
    }

    static String posString(SAMRecord a) {
        return ((a.getFlags() & 0x10) == 0 ? "0" : "1") + "\t" + a.getContig() + "\t" + (a.getStart() + a.getEnd()) / 2;
    }

    private static SamReader getSamReader(String path) throws IOException {
        SamInputResource resource;
        boolean isLocal = !path.startsWith("http");
        SamReaderFactory factory = SamReaderFactory.makeDefault().referenceSource((CRAMReferenceSource)new IGVReferenceSource()).validationStringency(ValidationStringency.SILENT);
        if (isLocal) {
            resource = SamInputResource.of((File)new File(path));
        } else {
            URL url = new URL(path);
            resource = SamInputResource.of((InputStream)new BufferedInputStream(HttpUtils.getInstance().openConnectionStream(url)));
        }
        return factory.open(resource);
    }
}

