/*
 * Decompiled with CFR 0.152.
 */
package org.igv.tools;

import java.io.PrintStream;
import org.igv.tools.StatusMonitor;

public class CommandLineStatusMonitor
implements StatusMonitor {
    private boolean interrupted = false;
    private double percentComplete = 0.0;
    private PrintStream outStream;

    public CommandLineStatusMonitor(PrintStream outStream) {
        this.outStream = outStream;
    }

    @Override
    public void setPercentComplete(double percentComplete) {
        this.percentComplete = Math.min(100.0, Math.max(0.0, percentComplete));
        if (percentComplete % 10.0 == 0.0) {
            this.outStream.println(percentComplete + "% ");
        } else {
            this.outStream.print(".");
        }
    }

    @Override
    public void incrementPercentComplete(double increment) {
        this.percentComplete += increment;
        this.outStream.println(this.percentComplete + "%");
        if (this.percentComplete >= 100.0) {
            this.outStream.println("Done");
        }
    }

    @Override
    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void setInterrupted(boolean interrupted) {
        this.interrupted = interrupted;
    }
}

