/*
 * Decompiled with CFR 0.152.
 */
package org.igv.seg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.igv.feature.FeatureUtils;
import org.igv.feature.LocusScore;
import org.igv.feature.genome.Genome;
import org.igv.seg.Segment;
import org.igv.track.TrackProperties;
import org.igv.track.TrackType;
import org.igv.ui.panel.ReferenceFrame;
import org.igv.util.ResourceLocator;

public class SegmentedDataSet {
    TrackType trackType = TrackType.COPY_NUMBER;
    float dataMax = -3.4028235E38f;
    float dataMin = Float.MAX_VALUE;
    private boolean logNormalized = false;
    private Map<String, Map<String, List<LocusScore>>> segments = new HashMap<String, Map<String, List<LocusScore>>>();
    private Set<String> chromosomes = new HashSet<String>();
    private List<String> headings = new ArrayList<String>();
    private Map<String, List<LocusScore>> wholeGenomeScoresCache = new HashMap<String, List<LocusScore>>();
    private long lastRefreshTime = 0L;
    private TrackProperties trackProperties;
    Genome genome;

    public SegmentedDataSet(Genome genome) {
        this.genome = genome;
    }

    public SegmentedDataSet(ResourceLocator locator, Genome genome) {
        this.genome = genome;
        this.sortLists();
    }

    public void sortLists() {
        for (Map.Entry<String, Map<String, List<LocusScore>>> sampleEntry : this.segments.entrySet()) {
            for (Map.Entry<String, List<LocusScore>> chrEntry : sampleEntry.getValue().entrySet()) {
                List<LocusScore> tmp = chrEntry.getValue();
                FeatureUtils.sortFeatureList(tmp);
            }
        }
    }

    public void addSegment(String heading, String c, int start, int end, float value, String desc) {
        List<LocusScore> segmentList;
        String chr = this.genome == null ? c : this.genome.getCanonicalChrName(c);
        Map<String, List<LocusScore>> chrSegments = this.segments.get(heading);
        if (chrSegments == null) {
            this.headings.add(heading);
            chrSegments = new HashMap<String, List<LocusScore>>();
            this.segments.put(heading, chrSegments);
        }
        if ((segmentList = chrSegments.get(chr)) == null) {
            segmentList = new ArrayList<LocusScore>();
            chrSegments.put(chr, segmentList);
        }
        segmentList.add(new Segment(start, start, end, end, value, desc));
        this.dataMax = Math.max(this.dataMax, value);
        this.dataMin = Math.min(this.dataMin, value);
        if (value < 0.0f) {
            this.logNormalized = true;
        }
        this.chromosomes.add(chr);
    }

    public Set<String> getChromosomes() {
        return this.chromosomes;
    }

    public List<LocusScore> getSegments(String sample, String chr) {
        if ("All".equals(chr)) {
            return this.getWholeGenomeScores(sample);
        }
        Map<String, List<LocusScore>> chrSegments = this.segments.get(sample);
        return chrSegments == null ? null : chrSegments.get(chr);
    }

    public List<String> getSampleNames() {
        return this.headings;
    }

    public TrackType getType() {
        return this.trackType;
    }

    public boolean isLogNormalized() {
        return this.logNormalized;
    }

    public double getDataMax() {
        return this.dataMax;
    }

    public double getDataMin() {
        return this.dataMin;
    }

    public List<LocusScore> getWholeGenomeScores(String sample) {
        List<LocusScore> wholeGenomeScores = this.wholeGenomeScoresCache.get(sample);
        if (wholeGenomeScores == null || wholeGenomeScores.isEmpty()) {
            wholeGenomeScores = new ArrayList<LocusScore>(1000);
            for (String chr : this.genome.getLongChromosomeNames()) {
                List<LocusScore> chrSegments = this.getSegments(sample, chr);
                if (chrSegments == null) continue;
                int lastgEnd = -1;
                for (LocusScore score : chrSegments) {
                    Segment seg = (Segment)score;
                    int gStart = this.genome.getGenomeCoordinate(chr, seg.getStart());
                    int gEnd = this.genome.getGenomeCoordinate(chr, seg.getEnd());
                    if (gEnd > lastgEnd) {
                        wholeGenomeScores.add(new Segment(gStart, gStart, gEnd, gEnd, seg.getScore(), seg.getDescription()));
                    }
                    lastgEnd = gEnd;
                }
            }
            this.wholeGenomeScoresCache.put(sample, wholeGenomeScores);
        }
        return wholeGenomeScores;
    }

    public TrackType getTrackType() {
        return this.trackType;
    }

    public void setTrackType(TrackType trackType) {
        this.trackType = trackType;
    }

    public void setTrackProperties(TrackProperties props) {
        this.trackProperties = props;
    }

    public TrackProperties getTrackProperties() {
        if (this.trackProperties == null) {
            this.trackProperties = new TrackProperties();
        }
        return this.trackProperties;
    }

    public LocusScore getSegmentAt(String sample, String chr, double position, ReferenceFrame frame) {
        List<LocusScore> scores = this.getSegments(sample, chr);
        if (scores == null) {
            return null;
        }
        double bpPerPixel = frame.getScale();
        int buffer = (int)(2.0 * bpPerPixel);
        return FeatureUtils.getFeatureAt(position, buffer, scores);
    }
}

