/*
 * Decompiled with CFR 0.152.
 */
package org.igv.sam.smrt;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import org.igv.sam.Alignment;
import org.igv.sam.AlignmentBlock;
import org.igv.sam.AlignmentTrack;
import org.igv.sam.ByteSubarray;
import org.igv.sam.smrt.SMRTKinetics;

public class SMRTKineticsRenderer {
    public static void drawSmrtKinetics(Alignment alignment, double bpStart, double locScale, Rectangle rowRect, Graphics g, AlignmentTrack.ColorOption colorOption) {
        short[] smrtFrameCounts;
        SMRTKinetics smrtKinetics = alignment.getSmrtKinetics();
        if (AlignmentTrack.ColorOption.SMRT_SUBREAD_IPD == colorOption) {
            smrtFrameCounts = smrtKinetics.getSmrtSubreadIpd();
        } else if (AlignmentTrack.ColorOption.SMRT_SUBREAD_PW == colorOption) {
            smrtFrameCounts = smrtKinetics.getSmrtSubreadPw();
        } else if (AlignmentTrack.ColorOption.SMRT_CCS_FWD_IPD == colorOption || AlignmentTrack.ColorOption.SMRT_CCS_REV_IPD == colorOption) {
            isForwardStrand = AlignmentTrack.ColorOption.SMRT_CCS_FWD_IPD == colorOption;
            smrtFrameCounts = smrtKinetics.getSmrtCcsIpd(isForwardStrand);
        } else {
            isForwardStrand = AlignmentTrack.ColorOption.SMRT_CCS_FWD_PW == colorOption;
            smrtFrameCounts = smrtKinetics.getSmrtCcsPw(isForwardStrand);
        }
        if (smrtFrameCounts != null) {
            int pY = (int)rowRect.getY();
            int dY = (int)rowRect.getHeight();
            int dX = (int)Math.max(1.0, 1.0 / locScale);
            block0: for (AlignmentBlock block : alignment.getAlignmentBlocks()) {
                ByteSubarray bases = block.getBases();
                int startOffset = bases.startOffset;
                int stopOffset = startOffset + bases.length;
                for (int i = startOffset; i < stopOffset; ++i) {
                    g.setColor(SMRTKineticsRenderer.getSmrtFrameCountColor(smrtFrameCounts[i]));
                    int blockIdx = i - block.getBases().startOffset;
                    int pX = (int)(((double)(block.getStart() + blockIdx) - bpStart) / locScale);
                    if ((double)pX > rowRect.getMaxX()) continue block0;
                    if ((double)(pX + dX) < rowRect.getX()) continue;
                    if (dX < 3) {
                        dX = 3;
                        --pX;
                    }
                    g.fillRect(pX, pY, dX, Math.max(1, dY - 2));
                }
            }
        }
    }

    private static Color getSmrtFrameCountColor(short shortFrameCount) {
        Color blendedColor;
        int transition1MaxFrameCount = 100;
        int transition2MaxFrameCount = 600;
        int transition3MaxFrameCount = 6000;
        Color color1 = Color.red;
        Color color2 = Color.yellow;
        Color color3 = Color.cyan;
        int frameCount = Short.toUnsignedInt(shortFrameCount);
        int alpha = Math.min(255, frameCount * 255 / 100);
        if (frameCount <= 100) {
            blendedColor = color1;
        } else if (frameCount <= 600) {
            float color2Fraction = (float)(frameCount - 100) / 500.0f;
            blendedColor = SMRTKineticsRenderer.blendColors(color1, color2, color2Fraction);
        } else if (frameCount <= 6000) {
            float color3Fraction = (float)(frameCount - 600) / 5400.0f;
            blendedColor = SMRTKineticsRenderer.blendColors(color2, color3, color3Fraction);
        } else {
            blendedColor = color3;
        }
        return new Color(blendedColor.getRed(), blendedColor.getGreen(), blendedColor.getBlue(), alpha);
    }

    private static int blendColorValue(int v1, int v2, float v2Frac) {
        return Math.min(255, (int)((float)v1 + (float)(v2 - v1) * v2Frac));
    }

    private static Color blendColors(Color c1, Color c2, float c2Frac) {
        assert ((double)c2Frac >= 0.0 && (double)c2Frac <= 1.0);
        return new Color(SMRTKineticsRenderer.blendColorValue(c1.getRed(), c2.getRed(), c2Frac), SMRTKineticsRenderer.blendColorValue(c1.getGreen(), c2.getGreen(), c2Frac), SMRTKineticsRenderer.blendColorValue(c1.getBlue(), c2.getBlue(), c2Frac));
    }
}

