/*
 * Decompiled with CFR 0.152.
 */
package org.igv.sam.smrt;

import org.igv.sam.Alignment;
import org.igv.sam.smrt.SMRTKineticsDecoder;

public class SMRTKinetics {
    private Alignment alignment;
    private short[] smrtSubreadIpd;
    private short[] smrtSubreadPw;
    private short[] smrtCcsIpd;
    private short[] smrtCcsPw;
    private short[] smrtSubreadIpdVals;
    private short[] smrtSubreadPwVals;
    private short[] smrtCcsFwdIpdVals;
    private short[] smrtCcsFwdPwVals;
    private short[] smrtCcsRevIpdVals;
    private short[] smrtCcsRevPwVals;

    public SMRTKinetics(Alignment alignment) {
        this.alignment = alignment;
    }

    private short[] parseSmrtKineticByteCodes(byte[] smrtKineticByteCodes, boolean reverseSequence) {
        if (smrtKineticByteCodes.length == 0) {
            return null;
        }
        int hardClipLength = this.alignment.getLeadingHardClipLength();
        int kineticValLength = smrtKineticByteCodes.length - hardClipLength;
        assert (kineticValLength > 0);
        short[] ccsKineticVals = new short[kineticValLength];
        int byteCodeIndex = 0;
        for (byte ccsKineticByteCode : smrtKineticByteCodes) {
            int valIndex = byteCodeIndex++;
            if (reverseSequence) {
                valIndex = smrtKineticByteCodes.length - (valIndex + 1);
            }
            if (valIndex < hardClipLength) continue;
            ccsKineticVals[valIndex -= hardClipLength] = SMRTKineticsDecoder.lookupFrameCount(ccsKineticByteCode);
        }
        return ccsKineticVals;
    }

    private short[] parseAuxSmrtKineticFrameCounts(short[] auxSmrtKineticFrameCounts, boolean reverseSequence) {
        if (auxSmrtKineticFrameCounts.length == 0) {
            return null;
        }
        int hardClipLength = this.alignment.getLeadingHardClipLength();
        int kineticValLength = auxSmrtKineticFrameCounts.length - hardClipLength;
        assert (kineticValLength > 0);
        short[] ccsKineticVals = new short[kineticValLength];
        int auxIndex = 0;
        for (short ccsKineticFrameCount : auxSmrtKineticFrameCounts) {
            int valIndex = auxIndex++;
            if (reverseSequence) {
                valIndex = auxSmrtKineticFrameCounts.length - (valIndex + 1);
            }
            if (valIndex < hardClipLength) continue;
            ccsKineticVals[valIndex -= hardClipLength] = ccsKineticFrameCount;
        }
        return ccsKineticVals;
    }

    private short[] getSmrtKineticsVals(short[] smrtKineticVals, String tag, boolean bytesReversedInBam) {
        if (smrtKineticVals == null && this.alignment.getAttribute(tag) != null) {
            boolean reverseSequence = bytesReversedInBam ^ this.alignment.isNegativeStrand();
            Object tagValue = this.alignment.getAttribute(tag);
            if (tagValue instanceof byte[]) {
                smrtKineticVals = this.parseSmrtKineticByteCodes((byte[])tagValue, reverseSequence);
            } else if (tagValue instanceof short[]) {
                smrtKineticVals = this.parseAuxSmrtKineticFrameCounts((short[])tagValue, reverseSequence);
            } else {
                throw new RuntimeException("Unexpected format in SMRT kinetic aux tag '" + tag + "'");
            }
        }
        return smrtKineticVals;
    }

    public short[] getSmrtSubreadIpd() {
        return this.getSmrtKineticsVals(this.smrtSubreadIpdVals, "ip", false);
    }

    public short[] getSmrtSubreadPw() {
        return this.getSmrtKineticsVals(this.smrtSubreadPwVals, "pw", false);
    }

    public short[] getSmrtCcsIpd(boolean isForwardStrand) {
        if (isForwardStrand ^ this.alignment.isNegativeStrand()) {
            return this.getSmrtKineticsVals(this.smrtCcsFwdIpdVals, "fi", false);
        }
        return this.getSmrtKineticsVals(this.smrtCcsRevIpdVals, "ri", true);
    }

    public short[] getSmrtCcsPw(boolean isForwardStrand) {
        if (isForwardStrand ^ this.alignment.isNegativeStrand()) {
            return this.getSmrtKineticsVals(this.smrtCcsFwdPwVals, "fp", false);
        }
        return this.getSmrtKineticsVals(this.smrtCcsRevPwVals, "rp", true);
    }
}

