/*
 * Decompiled with CFR 0.152.
 */
package org.igv.renderer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.util.List;
import org.igv.Globals;
import org.igv.feature.IGVFeature;
import org.igv.feature.SpliceJunctionFeature;
import org.igv.feature.Strand;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.prefs.PreferencesManager;
import org.igv.renderer.IGVFeatureRenderer;
import org.igv.track.FeatureTrack;
import org.igv.track.RenderContext;
import org.igv.track.Track;
import org.igv.ui.color.ColorUtilities;

public class SpliceJunctionRenderer
extends IGVFeatureRenderer {
    private static Logger log = LogManager.getLogger(SpliceJunctionRenderer.class);
    private static Color ARC_COLOR_NEG = new Color(50, 50, 150, 140);
    private static Color ARC_COLOR_POS = new Color(150, 50, 50, 140);
    private static Color ARC_COLOR_HIGHLIGHT_NEG = new Color(90, 90, 255, 255);
    private Color ARC_COLOR_HIGHLIGHT_POS = new Color(255, 90, 90, 255);
    private static Color COLOR_CENTERLINE = new Color(0, 0, 0, 100);
    private int maxDepth = 50;

    public SpliceJunctionRenderer() {
        if (Globals.isDarkMode()) {
            ARC_COLOR_NEG = ColorUtilities.modifyAlpha(Color.CYAN, 140);
            ARC_COLOR_POS = ColorUtilities.modifyAlpha(Color.RED, 140);
            ARC_COLOR_HIGHLIGHT_NEG = Color.BLUE;
            this.ARC_COLOR_HIGHLIGHT_POS = Color.RED;
            COLOR_CENTERLINE = new Color(255, 255, 255, 100);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(List<IGVFeature> featureList, RenderContext context, Rectangle trackRectangle, Track track) {
        if (featureList != null && !featureList.isEmpty()) {
            Graphics g2D = null;
            try {
                g2D = (Graphics2D)context.getGraphics().create();
                double origin = context.getOrigin();
                double locScale = context.getScale();
                double end = origin + locScale * (double)trackRectangle.width;
                IGVFeature selectedFeature = ((FeatureTrack)track).getSelectedFeature();
                boolean shouldShowFlankingRegions = PreferencesManager.getPreferences().getAsBoolean("SAM.SHOW_JUNCTION_FLANKINGREGIONS");
                for (IGVFeature feature : featureList) {
                    SpliceJunctionFeature junctionFeature = (SpliceJunctionFeature)feature;
                    if (!((double)junctionFeature.getEnd() > origin) || !((double)junctionFeature.getStart() < end)) continue;
                    boolean shouldHighlight = junctionFeature.isSameJunction(selectedFeature);
                    this.drawFeature(junctionFeature, shouldShowFlankingRegions, shouldHighlight, origin, locScale, trackRectangle, track, (Graphics2D)g2D);
                }
                g2D.setColor(COLOR_CENTERLINE);
                g2D.drawLine(trackRectangle.x, (int)trackRectangle.getCenterY(), trackRectangle.x + trackRectangle.width, (int)trackRectangle.getCenterY());
            }
            finally {
                g2D.dispose();
            }
        }
    }

    protected void drawFeature(SpliceJunctionFeature junctionFeature, boolean shouldShowFlankingRegions, boolean highlight, double origin, double locScale, Rectangle trackRectangle, Track track, Graphics2D g2D) {
        Color trackColor;
        int flankingStart = junctionFeature.getStart();
        int flankingEnd = junctionFeature.getEnd();
        int junctionStart = junctionFeature.getJunctionStart();
        int junctionEnd = junctionFeature.getJunctionEnd();
        int pixelFeatureStart = (int)Math.round(((double)flankingStart - origin) / locScale);
        int pixelFeatureEnd = (int)Math.round(((double)flankingEnd - origin) / locScale);
        int pixelJunctionStart = (int)Math.round(((double)junctionStart - origin) / locScale);
        int pixelJunctionEnd = (int)Math.round(((double)junctionEnd - origin) / locScale);
        Strand strand = junctionFeature.getStrand();
        float depth = junctionFeature.getJunctionDepth();
        Color featureColor = junctionFeature.getColor();
        boolean isPositiveStrand = true;
        if (strand != null && strand.equals((Object)Strand.NEGATIVE)) {
            isPositiveStrand = false;
        }
        Color color = trackColor = isPositiveStrand ? track.getColor() : track.getAltColor();
        if (trackColor == null) {
            trackColor = track.getDefaultColor();
        }
        Color color2 = trackColor != null ? SpliceJunctionRenderer.adjustAlpha(trackColor, highlight) : (featureColor != null ? SpliceJunctionRenderer.adjustAlpha(featureColor, highlight) : (isPositiveStrand ? (highlight ? this.ARC_COLOR_HIGHLIGHT_POS : ARC_COLOR_POS) : (highlight ? ARC_COLOR_HIGHLIGHT_NEG : ARC_COLOR_NEG)));
        g2D.setColor(color2);
        int maxPossibleArcHeight = (trackRectangle.height - 1) / 2;
        if (shouldShowFlankingRegions) {
            if (junctionFeature.hasFlankingRegionDepthArrays()) {
                int startFlankingRegionPixelLength = pixelJunctionStart - pixelFeatureStart;
                int endFlankingRegionPixelLength = pixelFeatureEnd - pixelJunctionEnd;
                this.drawFlankingRegion(g2D, pixelFeatureStart, startFlankingRegionPixelLength, junctionFeature.getStartFlankingRegionDepthArray(), maxPossibleArcHeight, trackRectangle, isPositiveStrand);
                this.drawFlankingRegion(g2D, pixelJunctionEnd + 1, endFlankingRegionPixelLength, junctionFeature.getEndFlankingRegionDepthArray(), maxPossibleArcHeight, trackRectangle, isPositiveStrand);
            } else {
                int overlapRectHeight = 3;
                int overlapRectTopX = (int)trackRectangle.getCenterY() + (isPositiveStrand ? -2 : 0);
                if (pixelFeatureStart < pixelJunctionStart) {
                    g2D.fillRect(pixelFeatureStart, overlapRectTopX, pixelJunctionStart - pixelFeatureStart, overlapRectHeight);
                }
                if (pixelJunctionEnd < pixelFeatureEnd) {
                    g2D.fillRect(pixelJunctionEnd, overlapRectTopX, pixelFeatureEnd - pixelJunctionEnd, overlapRectHeight);
                }
            }
        }
        double minArcHeightProportion = 0.33;
        int innerArcHeight = (int)((double)maxPossibleArcHeight * minArcHeightProportion);
        float depthProportionOfMax = Math.min(1.0f, depth / (float)this.maxDepth);
        int arcWidth = Math.max(1, (int)((1.0 - minArcHeightProportion) * (double)maxPossibleArcHeight * (double)depthProportionOfMax));
        int outerArcHeight = innerArcHeight + arcWidth;
        int arcBeginY = (int)trackRectangle.getCenterY() + (isPositiveStrand ? -1 : 1);
        int outerArcPeakY = isPositiveStrand ? arcBeginY - outerArcHeight : arcBeginY + outerArcHeight;
        int innerArcPeakY = isPositiveStrand ? arcBeginY - innerArcHeight : arcBeginY + innerArcHeight;
        int outerBezierY = arcBeginY + (int)(1.3 * (double)(outerArcPeakY - arcBeginY));
        int innerBezierY = arcBeginY + (int)(1.3 * (double)(innerArcPeakY - arcBeginY));
        int bezierXPad = Math.max(1, (pixelJunctionEnd - pixelJunctionStart) / 30);
        GeneralPath arcPath = new GeneralPath();
        arcPath.moveTo(pixelJunctionStart, arcBeginY);
        arcPath.curveTo(pixelJunctionStart - bezierXPad, outerBezierY, pixelJunctionEnd + bezierXPad, outerBezierY, pixelJunctionEnd, arcBeginY);
        arcPath.curveTo(pixelJunctionEnd + bezierXPad, innerBezierY, pixelJunctionStart - bezierXPad, innerBezierY, pixelJunctionStart, arcBeginY);
        g2D.setClip(new Rectangle(pixelJunctionStart, trackRectangle.y, pixelJunctionEnd - pixelJunctionStart, trackRectangle.height));
        g2D.draw(arcPath);
        g2D.fill(arcPath);
        g2D.setClip(null);
    }

    private static Color adjustAlpha(Color featureColor, boolean highlight) {
        int r = featureColor.getRed();
        int g = featureColor.getGreen();
        int b = featureColor.getBlue();
        int alpha = highlight ? 255 : 140;
        Color color = new Color(r, g, b, alpha);
        return color;
    }

    protected void drawFlankingRegion(Graphics g2D, int pixelStart, int pixelLength, int[] regionDepthArray, int maxPossibleArcHeight, Rectangle trackRectangle, boolean isPositiveStrand) {
        for (int i = 0; i < pixelLength; ++i) {
            float arrayIndicesPerPixel = (float)regionDepthArray.length / (float)pixelLength;
            int flankingRegionArrayPixelMinIndex = (int)((float)i * arrayIndicesPerPixel);
            int flankingRegionArrayPixelMaxIndex = (int)((float)(i + 1) * arrayIndicesPerPixel);
            flankingRegionArrayPixelMinIndex = Math.max(0, Math.min(flankingRegionArrayPixelMinIndex, regionDepthArray.length - 1));
            flankingRegionArrayPixelMaxIndex = Math.max(0, Math.min(flankingRegionArrayPixelMaxIndex, regionDepthArray.length - 1));
            int meanDepthThisPixel = 0;
            for (int j = flankingRegionArrayPixelMinIndex; j <= flankingRegionArrayPixelMaxIndex; ++j) {
                meanDepthThisPixel += regionDepthArray[j];
            }
            meanDepthThisPixel /= flankingRegionArrayPixelMaxIndex - flankingRegionArrayPixelMinIndex + 1;
            meanDepthThisPixel = Math.min(this.maxDepth, meanDepthThisPixel);
            int pixelHeight = Math.max(maxPossibleArcHeight * meanDepthThisPixel / this.maxDepth, 2);
            g2D.fillRect(pixelStart + i, (int)trackRectangle.getCenterY() + (isPositiveStrand ? -pixelHeight : 0), 1, pixelHeight);
        }
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }
}

