/*
 * Decompiled with CFR 0.152.
 */
package org.igv.renderer;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.igv.renderer.AbstractColorScale;
import org.igv.ui.color.ColorUtilities;

public class MappedColorScale
extends AbstractColorScale {
    public static String serializationClassId = "MappedColorScale";
    Map<String, Color> colorMap = new HashMap<String, Color>();
    boolean defaultCS = false;

    public MappedColorScale(String serializedInstance) {
        String[] tokens = serializedInstance.split(";");
        for (int i = 1; i < tokens.length; ++i) {
            String[] keyValue = tokens[i].split(" ");
            if (keyValue.length != 2) continue;
            String key = keyValue[0].trim();
            Color c = ColorUtilities.stringToColor(keyValue[1]);
            this.colorMap.put(key, c);
        }
    }

    public MappedColorScale(Map<String, Color> colorMap) {
        this.colorMap.putAll(colorMap);
    }

    @Override
    public boolean isDefault() {
        return this.defaultCS;
    }

    @Override
    public String asString() {
        StringBuffer buf = new StringBuffer();
        buf.append(serializationClassId);
        for (Map.Entry<String, Color> mapEntry : this.colorMap.entrySet()) {
            buf.append(";");
            buf.append(mapEntry.getKey() + " ");
            buf.append(ColorUtilities.colorToString(mapEntry.getValue()));
        }
        return buf.toString();
    }

    public int getSize() {
        return this.colorMap.size();
    }

    public boolean isSame(MappedColorScale anotherCS) {
        if (this.getSize() != anotherCS.getSize()) {
            return false;
        }
        for (String key : this.colorMap.keySet()) {
            if (this.getColor(key).equals(anotherCS.getColor(key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Color getColor(String key) {
        return this.colorMap.containsKey(key) ? this.colorMap.get(key) : defaultColor;
    }

    @Override
    public Color getNoDataColor() {
        return this.noDataColor;
    }
}

