/*
 * Decompiled with CFR 0.152.
 */
package org.igv.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.igv.feature.LocusScore;
import org.igv.feature.Strand;
import org.igv.feature.genome.GenomeManager;
import org.igv.feature.genome.SeqUtils;
import org.igv.prefs.IGVPreferences;
import org.igv.renderer.BarChartRenderer;
import org.igv.renderer.SequenceRenderer;
import org.igv.renderer.XYPlotRenderer;
import org.igv.track.RenderContext;
import org.igv.track.Track;
import org.igv.ui.IGV;

public class DynSeqRenderer
extends XYPlotRenderer {
    static Map<Character, Map<String, String>> letterPaths = new HashMap<Character, Map<String, String>>();
    BarChartRenderer barChartRenderer = new BarChartRenderer();
    Map<Character, Color> nucleotideColors = SequenceRenderer.getNucleotideColors();

    @Override
    public String getDisplayName() {
        return "DynSeq";
    }

    @Override
    protected Color getBorderColor(Track track, IGVPreferences prefs, Color altColor) {
        return Color.lightGray;
    }

    @Override
    protected void drawDataPoint(Color graphColor, int dx, int pX, int baseY, int pY, LocusScore score, RenderContext context) {
        int pixelsPerBP = (int)(1.0 / context.getReferenceFrame().getScale());
        if (pixelsPerBP < 2) {
            this.barChartRenderer.drawDataPoint(graphColor, dx, pX, baseY, pY, score, context);
        } else {
            String chr = context.getChr();
            double origin = context.getReferenceFrame().getOrigin();
            double locScale = context.getReferenceFrame().getScale();
            dx = (int)Math.ceil(1.0 / locScale) + 1;
            byte[] seq = GenomeManager.getInstance().getCurrentGenome().getSequence(chr, score.getStart(), score.getEnd());
            for (int pos = score.getStart(); pos < score.getEnd(); ++pos) {
                char base = (char)seq[pos - score.getStart()];
                if (IGV.getInstance().getSequenceTrack().getStrand() == Strand.NEGATIVE) {
                    base = SeqUtils.complementChar(base);
                }
                pX = (int)(((double)pos - origin) / locScale);
                this.renderDynSeq(context.getGraphics(), pixelsPerBP, pX, baseY, pY, base);
            }
        }
    }

    private void renderDynSeq(Graphics2D ctx, int dx, int pX, int baseY, int pY, char base) {
        int rectY = Math.min(baseY, pY);
        int rectHeight = Math.abs(pY - baseY);
        boolean isNegative = pY > baseY;
        Color nucleotideColor = this.nucleotideColors.getOrDefault(Character.valueOf(base), Color.GRAY);
        this.drawLetterGlyph(ctx, base, pX, rectY, dx, rectHeight, nucleotideColor, isNegative);
    }

    private void drawLetterGlyph(Graphics2D ctx, char base, int x, int y, int width, int height, Color color, boolean flipVertical) {
        Map<String, String> pathData = letterPaths.getOrDefault(Character.valueOf(base), letterPaths.get(Character.valueOf('N')));
        Graphics2D g2 = (Graphics2D)ctx.create();
        g2.setColor(color);
        if (flipVertical) {
            g2.translate(x + width / 2, y + height / 2);
            g2.scale(1.0, -1.0);
            g2.translate(-(x + width / 2), -(y + height / 2));
        }
        this.drawSVGPath(g2, pathData.get("main"), x, y, width, height);
        if (pathData.containsKey("overlay")) {
            g2.setColor(Color.WHITE);
            this.drawSVGPath(g2, pathData.get("overlay"), x, y, width, height);
        }
        g2.dispose();
    }

    private void drawSVGPath(Graphics2D ctx, String pathString, int x, int y, int width, int height) {
        double scaleX = (double)width / 100.0;
        double scaleY = (double)height / 100.0;
        Pattern pattern = Pattern.compile("[MLC][^MLC]*");
        Matcher matcher = pattern.matcher(pathString);
        Path2D.Double path = new Path2D.Double();
        while (matcher.find()) {
            String command = matcher.group();
            char type = command.charAt(0);
            String[] coordStrs = command.substring(1).trim().split("[\\s,]+");
            double[] coords = new double[coordStrs.length];
            for (int i = 0; i < coordStrs.length; ++i) {
                coords[i] = Double.parseDouble(coordStrs[i]);
            }
            if (type == 'M' && coords.length >= 2) {
                path.moveTo((double)x + coords[0] * scaleX, (double)y + coords[1] * scaleY);
                continue;
            }
            if (type == 'L' && coords.length >= 2) {
                path.lineTo((double)x + coords[0] * scaleX, (double)y + coords[1] * scaleY);
                continue;
            }
            if (type != 'C' || coords.length < 6) continue;
            path.curveTo((double)x + coords[0] * scaleX, (double)y + coords[1] * scaleY, (double)x + coords[2] * scaleX, (double)y + coords[3] * scaleY, (double)x + coords[4] * scaleX, (double)y + coords[5] * scaleY);
        }
        ctx.fill(path);
    }

    static {
        HashMap<String, String> aPaths = new HashMap<String, String>();
        aPaths.put("main", "M 0 100 L 33 0 L 66 0 L 100 100 L 75 100 L 66 75 L 33 75 L 25 100 L 0 100");
        aPaths.put("overlay", "M 41 55 L 50 25 L 58 55 L 41 55");
        letterPaths.put(Character.valueOf('A'), aPaths);
        letterPaths.put(Character.valueOf('a'), aPaths);
        HashMap<String, String> cPaths = new HashMap<String, String>();
        cPaths.put("main", "M 100 28 C 100 -13 0 -13 0 50 C 0 113 100 113 100 72 L 75 72 C 75 90 30 90 30 50 C 30 10 75 10 75 28 L 100 28");
        letterPaths.put(Character.valueOf('C'), cPaths);
        letterPaths.put(Character.valueOf('c'), cPaths);
        HashMap<String, String> gPaths = new HashMap<String, String>();
        gPaths.put("main", "M 100 28 C 100 -13 0 -13 0 50 C 0 113 100 113 100 72 L 100 48 L 55 48 L 55 72 L 75 72 C 75 90 30 90 30 50 C 30 10 75 5 75 28 L 100 28");
        letterPaths.put(Character.valueOf('G'), gPaths);
        letterPaths.put(Character.valueOf('g'), gPaths);
        HashMap<String, String> tPaths = new HashMap<String, String>();
        tPaths.put("main", "M 0 0 L 0 20 L 35 20 L 35 100 L 65 100 L 65 20 L 100 20 L 100 0 L 0 0");
        letterPaths.put(Character.valueOf('T'), tPaths);
        letterPaths.put(Character.valueOf('t'), tPaths);
        HashMap<String, String> nPaths = new HashMap<String, String>();
        nPaths.put("main", "M 0 100 L 0 0 L 20 0 L 80 75 L 80 0 L 100 0 L 100 100 L 80 100 L 20 25 L 20 100 L 0 100");
        letterPaths.put(Character.valueOf('N'), nPaths);
    }
}

