/*
 * Decompiled with CFR 0.152.
 */
package org.igv.renderer;

import java.util.Collection;
import org.igv.session.Persistable;
import org.igv.track.Track;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DataRange
implements Persistable {
    private Type type = Type.LINEAR;
    private float minimum = 0.0f;
    private float baseline = 0.0f;
    public float maximum;
    private boolean flipAxis = false;
    private boolean drawBaseline = true;

    public DataRange() {
    }

    public DataRange(float minimum, float maximum) {
        this(minimum, minimum, maximum, true);
    }

    public DataRange(float minimum, float baseline, float maximum) {
        this(minimum, baseline, maximum, true);
    }

    public DataRange(float minimum, float baseline, float maximum, boolean drawBaseline) {
        this(minimum, baseline, maximum, drawBaseline, false);
    }

    public DataRange(float minimum, float baseline, float maximum, boolean drawBaseline, boolean isLog) {
        this.minimum = minimum;
        this.baseline = baseline;
        this.maximum = maximum;
        this.drawBaseline = drawBaseline;
        this.type = isLog ? Type.LOG : Type.LINEAR;
    }

    public DataRange(Element element, Integer version) {
        String tmp = element.getAttribute("type");
        if (tmp != null) {
            this.type = Type.valueOf(tmp);
        }
        if ((tmp = element.getAttribute("minimum")) != null) {
            this.minimum = Float.parseFloat(tmp);
        }
        if ((tmp = element.getAttribute("baseline")) != null) {
            this.baseline = Float.parseFloat(tmp);
        }
        if ((tmp = element.getAttribute("maximum")) != null) {
            this.maximum = Float.parseFloat(tmp);
        }
        if ((tmp = element.getAttribute("flipAxis")) != null) {
            this.flipAxis = Boolean.parseBoolean(tmp);
        }
        if ((tmp = element.getAttribute("drawBaseline")) != null) {
            this.drawBaseline = Boolean.parseBoolean(tmp);
        }
    }

    public static DataRange getFromTracks(Collection<? extends Track> tracks) {
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        float mid = 0.0f;
        boolean drawBaseline = true;
        boolean isLog = true;
        for (Track track : tracks) {
            DataRange dr = track.getDataRange();
            min = Math.min(min, dr.getMinimum());
            max = Math.max(max, dr.getMaximum());
            mid += dr.getBaseline();
            drawBaseline &= dr.isDrawBaseline();
            isLog &= dr.isLog();
        }
        if ((mid /= (float)tracks.size()) < min) {
            mid = min;
        } else if (mid > max) {
            min = max;
        }
        return new DataRange(min, mid, max, drawBaseline, isLog);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean isLog() {
        return this.type == Type.LOG;
    }

    public float getMinimum() {
        return this.minimum;
    }

    public float getBaseline() {
        return this.baseline;
    }

    public float getMaximum() {
        return this.maximum;
    }

    public boolean isFlipAxis() {
        return this.flipAxis;
    }

    public boolean isDrawBaseline() {
        return this.drawBaseline;
    }

    public void setDrawBaseline(boolean drawBaseline) {
        this.drawBaseline = drawBaseline;
    }

    @Override
    public void marshalXML(Document document, Element element) {
        element.setAttribute("baseline", String.valueOf(this.baseline));
        element.setAttribute("drawBaseline", String.valueOf(this.drawBaseline));
        element.setAttribute("flipAxis", String.valueOf(this.flipAxis));
        element.setAttribute("maximum", String.valueOf(this.maximum));
        element.setAttribute("minimum", String.valueOf(this.minimum));
        element.setAttribute("type", this.type.toString());
    }

    @Override
    public void unmarshalXML(Element element, Integer version) {
        this.baseline = Float.parseFloat(element.getAttribute("baseline"));
        this.drawBaseline = Boolean.parseBoolean(element.getAttribute("drawBaseLine"));
        this.flipAxis = Boolean.parseBoolean(element.getAttribute("flipAxis"));
        this.maximum = Float.parseFloat(element.getAttribute("maximum"));
        this.minimum = Float.parseFloat(element.getAttribute("minimum"));
    }

    public static enum Type {
        LOG,
        LINEAR;

    }
}

