/*
 * Decompiled with CFR 0.152.
 */
package org.igv.logging;

import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.igv.DirectoryManager;
import org.igv.logging.LogFormatter;

public class LogFileHandler
extends Handler {
    static LogFileHandler instance = new LogFileHandler();
    private FileHandler fileHandler;

    public static synchronized LogFileHandler getInstance() {
        return instance;
    }

    private LogFileHandler() {
    }

    public void updateHandler() {
        if (this.fileHandler != null) {
            this.fileHandler.flush();
            this.fileHandler.close();
        }
        String logFilename = new File(DirectoryManager.getIgvDirectory(), "igv%g.log").getAbsolutePath();
        try {
            this.fileHandler = new FileHandler(logFilename, 100000, 2, true);
            this.fileHandler.setFormatter(new LogFormatter());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void closeHandler() {
        this.fileHandler.flush();
        this.fileHandler.close();
        this.fileHandler = null;
    }

    @Override
    public void publish(LogRecord record) {
        if (this.fileHandler != null) {
            this.fileHandler.publish(record);
        }
    }

    @Override
    public void flush() {
        if (this.fileHandler != null) {
            this.fileHandler.flush();
        }
    }

    @Override
    public void close() throws SecurityException {
        if (this.fileHandler != null) {
            this.fileHandler.close();
        }
    }
}

