/*
 * Decompiled with CFR 0.152.
 */
package org.igv.jbrowse;

import htsjdk.samtools.SAMTag;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.igv.Globals;
import org.igv.bedpe.BedPE;
import org.igv.jbrowse.JsonUtils;
import org.igv.jbrowse.Mate;
import org.igv.sam.Alignment;
import org.igv.sam.ReadMate;
import org.igv.sam.SupplementaryAlignment;
import org.igv.variant.Variant;

class Chord {
    String uniqueId;
    String color;
    String refName;
    int start;
    int end;
    Mate mate;

    private Chord() {
    }

    public static Chord fromBedPE(BedPE f) {
        Chord c = new Chord();
        String chr1 = Chord.shortName(f.getChr1());
        String chr2 = Chord.shortName(f.getChr2());
        c.uniqueId = chr1 + ":" + f.getStart1() + "-" + f.getEnd1() + "_" + chr2 + ":" + f.getStart2() + "-" + f.getEnd2();
        c.refName = chr1;
        c.start = f.getStart1();
        c.end = f.getEnd1();
        c.mate = new Mate(chr2, f.getStart2(), f.getEnd2());
        return c;
    }

    public static Chord fromPEAlignment(Alignment a) {
        Chord c = new Chord();
        ReadMate readMate = a.getMate();
        c.uniqueId = a.getReadName();
        c.refName = Chord.shortName(a.getChr());
        c.start = a.getStart();
        c.end = a.getEnd();
        c.mate = new Mate(Chord.shortName(readMate.getChr()), readMate.getStart(), readMate.getStart() + 1);
        return c;
    }

    public static List<Chord> fromSAString(Alignment a) {
        String sastring = a.getAttribute(SAMTag.SA.name()).toString();
        String[] records = Globals.semicolonPattern.split(sastring);
        ArrayList<Chord> chords = new ArrayList<Chord>();
        int n = 0;
        for (String rec : records) {
            SupplementaryAlignment sa = SupplementaryAlignment.fromSingleSaTagRecord(rec);
            if (sa.start == a.getStart()) continue;
            Chord c = new Chord();
            c.uniqueId = a.getReadName() + "_" + n++;
            c.refName = Chord.shortName(a.getChr());
            c.start = a.getStart();
            c.end = a.getEnd();
            c.mate = new Mate(Chord.shortName(sa.chr), sa.start, sa.start + sa.getLengthOnReference());
            chords.add(c);
        }
        return chords;
    }

    public static Chord fromVariant(Variant v) {
        Chord c = new Chord();
        Map<String, Object> attrs = v.getAttributes();
        String chr2 = Chord.shortName(attrs.get("CHR2").toString());
        int end2 = Integer.parseInt(attrs.get("END").toString());
        int start2 = end2 - 1;
        String chr1 = Chord.shortName(v.getChr());
        int start1 = v.getStart();
        int end1 = v.getEnd();
        c.uniqueId = chr1 + "_" + start1 + ":" + end1 + "-" + chr2 + "_" + start2 + ":" + end2;
        c.refName = chr1;
        c.start = start1;
        c.end = end1;
        c.mate = new Mate(chr2, start2, end2);
        return c;
    }

    public String toJson() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        buf.append(JsonUtils.toJson("uniqueId", this.uniqueId));
        buf.append(",");
        buf.append(JsonUtils.toJson("color", this.color));
        buf.append(",");
        buf.append(JsonUtils.toJson("refName", this.refName));
        buf.append(",");
        buf.append(JsonUtils.toJson("start", this.start));
        buf.append(",");
        buf.append(JsonUtils.toJson("end", this.end));
        buf.append(",");
        buf.append("\"mate\":");
        buf.append(this.mate.toJson());
        buf.append("}");
        return buf.toString();
    }

    static String shortName(String chr) {
        return chr.startsWith("chr") ? chr.substring(3) : chr;
    }
}

