/*
 * Decompiled with CFR 0.152.
 */
package org.igv.hic;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.igv.hic.HicFile;

public class NormalizationVector {
    private final SeekableStream fileChannel;
    private final long filePosition;
    private final int nValues;
    private final HicFile.DataType dataType;
    private final String type;
    private final int chrIdx;
    private final String unit;
    private final int resolution;
    private Cache cache;

    public NormalizationVector(SeekableStream fileChannel, long filePosition, int nValues, HicFile.DataType dataType) {
        this(fileChannel, filePosition, nValues, dataType, null, 0, null, 0);
    }

    public NormalizationVector(SeekableStream fileChannel, long filePosition, int nValues, HicFile.DataType dataType, String type, int chrIdx, String unit, int resolution) {
        this.fileChannel = fileChannel;
        this.filePosition = filePosition;
        this.nValues = nValues;
        this.dataType = dataType;
        this.type = type;
        this.chrIdx = chrIdx;
        this.unit = unit;
        this.resolution = resolution;
        this.cache = null;
    }

    public int getnValues() {
        return this.nValues;
    }

    public double[] getValues(int startBin, int endBin) throws IOException {
        if (startBin < 0) {
            startBin = 0;
        }
        if (endBin > this.nValues) {
            endBin = this.nValues;
        }
        if (startBin >= endBin) {
            return new double[0];
        }
        if (this.cache == null || startBin < this.cache.start || endBin >= this.cache.end) {
            int read;
            int r;
            int adjustedStart = Math.max(0, startBin - 1000);
            int adjustedEnd = Math.min(this.nValues, endBin + 1000);
            int n = adjustedEnd - adjustedStart;
            long startPosition = this.filePosition + (long)adjustedStart * (long)this.dataType.getByteSize();
            int sizeInBytes = n * this.dataType.getByteSize();
            byte[] byteArray = new byte[sizeInBytes];
            for (read = 0; read < sizeInBytes; read += r) {
                this.fileChannel.seek(startPosition + (long)read);
                r = this.fileChannel.read(byteArray, read, sizeInBytes);
                if (r < 0) break;
            }
            if (read < sizeInBytes) {
                return null;
            }
            ByteBuffer buf = ByteBuffer.wrap(byteArray);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            double[] values = new double[n];
            for (int i = 0; i < n; ++i) {
                values[i] = this.dataType == HicFile.DataType.DOUBLE ? buf.getDouble() : (double)buf.getFloat();
            }
            this.cache = new Cache(adjustedStart, adjustedEnd, values);
        }
        int sliceStart = startBin - this.cache.start;
        int sliceLength = Math.min(endBin - startBin + 1, this.cache.values.length - sliceStart);
        return Arrays.copyOfRange(this.cache.values, sliceStart, sliceStart + sliceLength);
    }

    public String getKey() {
        return NormalizationVector.getNormalizationVectorKey(this.type, this.chrIdx, this.unit, this.resolution);
    }

    public static String getNormalizationVectorKey(String type, int chrIdx, String unit, int resolution) {
        return type + "_" + chrIdx + "_" + unit + "_" + resolution;
    }

    private static class Cache {
        final int start;
        final int end;
        final double[] values;

        Cache(int start, int end, double[] values) {
            this.start = start;
            this.end = end;
            this.values = values;
        }
    }
}

