/*
 * Decompiled with CFR 0.152.
 */
package org.igv.hic;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;

public class BinaryParser {
    private final ByteBuffer buffer;

    public BinaryParser(ByteBuffer buffer) {
        this(buffer, true);
    }

    public BinaryParser(ByteBuffer buffer, boolean littleEndian) {
        this.buffer = buffer;
        if (littleEndian) {
            this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            this.buffer.order(ByteOrder.BIG_ENDIAN);
        }
    }

    public int available() {
        return this.buffer.remaining();
    }

    public boolean hasNext() {
        return this.buffer.hasRemaining();
    }

    public int getByte() {
        return this.buffer.get() & 0xFF;
    }

    public short getShort() {
        return this.buffer.getShort();
    }

    public int getUShort() {
        return this.buffer.getShort() & 0xFFFF;
    }

    public int getInt() {
        return this.buffer.getInt();
    }

    public long getUInt() {
        return (long)this.buffer.getInt() & 0xFFFFFFFFL;
    }

    public long getLong() {
        return this.buffer.getLong();
    }

    public float getFloat() {
        return this.buffer.getFloat();
    }

    public double getDouble() {
        return this.buffer.getDouble();
    }

    public String getString() {
        return this.getString(-1);
    }

    public String getString(int len) {
        byte c;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (this.buffer.hasRemaining() && (len < 0 || i < len) && (c = this.buffer.get()) != 0) {
            sb.append((char)c);
            if (len <= 0) continue;
            ++i;
        }
        return sb.toString();
    }

    public String getFixedLengthString(int len) {
        byte[] bytes = new byte[len];
        this.buffer.get(bytes);
        int firstNull = -1;
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != 0) continue;
            firstNull = i;
            break;
        }
        if (firstNull != -1) {
            return new String(bytes, 0, firstNull, StandardCharsets.UTF_8);
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public String getFixedLengthTrimmedString(int len) {
        byte[] bytes = new byte[len];
        this.buffer.get(bytes);
        return new String(bytes, StandardCharsets.UTF_8).trim();
    }

    public void skip(int n) {
        this.buffer.position(this.buffer.position() + n);
    }

    public VPointer getVPointer() {
        long rawValue = this.buffer.getLong();
        long block = rawValue >>> 16;
        int offset = (int)(rawValue & 0xFFFFL);
        return new VPointer(block, offset);
    }

    public int position() {
        return this.buffer.position();
    }

    public static class VPointer {
        public final long block;
        public final int offset;

        public VPointer(long block, int offset) {
            this.block = block;
            this.offset = offset;
        }

        public boolean isLessThan(VPointer vp) {
            return this.block < vp.block || this.block == vp.block && this.offset < vp.offset;
        }

        public boolean isGreaterThan(VPointer vp) {
            return this.block > vp.block || this.block == vp.block && this.offset > vp.offset;
        }

        public String toString() {
            return this.block + ":" + this.offset;
        }
    }
}

