/*
 * Decompiled with CFR 0.152.
 */
package org.igv.feature.genome.load;

import java.io.File;
import java.io.IOException;
import org.igv.feature.genome.Genome;
import org.igv.feature.genome.fasta.FastaUtils;
import org.igv.feature.genome.load.GenomeConfig;
import org.igv.feature.genome.load.GenomeLoader;
import org.igv.util.FileUtils;
import org.igv.util.HttpUtils;
import org.igv.util.Utilities;

public class FastaGenomeLoader
extends GenomeLoader {
    private String genomePath;

    public FastaGenomeLoader(String genomePath) {
        this.genomePath = genomePath;
    }

    @Override
    public Genome loadGenome() throws IOException {
        String name;
        GenomeConfig config = new GenomeConfig();
        String id = this.genomePath;
        if (HttpUtils.isRemoteURL(this.genomePath)) {
            name = Utilities.getFileNameFromURL(this.genomePath);
        } else {
            File file = new File(this.genomePath);
            if (!file.exists()) {
                throw new IOException(this.genomePath + " does not exist, could not load genome");
            }
            name = file.getName();
        }
        config.id = id;
        config.setName(name);
        if (this.genomePath.endsWith(".2bit")) {
            config.twoBitURL = this.genomePath;
        } else {
            Object fastaIndexPath;
            String fastaPath;
            if (this.genomePath.endsWith(".fai")) {
                fastaPath = this.genomePath.substring(0, this.genomePath.length() - 4);
                fastaIndexPath = this.genomePath;
            } else {
                fastaPath = this.genomePath;
                fastaIndexPath = this.genomePath + ".fai";
            }
            if (!FileUtils.isRemote(fastaPath) && !FileUtils.resourceExists((String)fastaIndexPath)) {
                FastaUtils.createIndexFile(fastaPath, (String)fastaIndexPath);
            }
            config.fastaURL = fastaPath;
            config.indexURL = fastaIndexPath;
        }
        return new Genome(config);
    }
}

