/*
 * Decompiled with CFR 0.152.
 */
package org.igv.feature.genome;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.igv.Globals;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.prefs.IGVPreferences;
import org.igv.prefs.PreferencesManager;
import org.igv.ui.genome.GenomeListItem;
import org.igv.ui.util.MessageUtils;
import org.igv.util.HttpUtils;

public class HostedGenomes {
    private static Logger log = LogManager.getLogger(HostedGenomes.class);
    private static String[] legacyColumns = new String[]{"common name", "url", "assembly"};
    private static CopyOnWriteArrayList<GenomeListItem> records;
    private static Map<String, GenomeListItem> hostedGenomesMap;

    public static List<GenomeListItem> getRecords() {
        if (records == null) {
            records = new CopyOnWriteArrayList<GenomeListItem>(HostedGenomes.readRecords());
        }
        return records;
    }

    public static GenomeListItem getGenomeListItem(String genomeId) {
        if (hostedGenomesMap == null) {
            hostedGenomesMap = new HashMap<String, GenomeListItem>();
            for (GenomeListItem record : HostedGenomes.getRecords()) {
                hostedGenomesMap.put(record.getId(), record);
            }
        }
        return hostedGenomesMap.get(genomeId);
    }

    private static List<GenomeListItem> readRecords() {
        records = new CopyOnWriteArrayList();
        IGVPreferences preferences = PreferencesManager.getPreferences();
        String genomesServerURL = preferences.get("IGV.genome.sequence.dir");
        String backupGenomesServerURL = preferences.get("IGV.backup.genome.sequence.dir");
        String genarkURL = "https://hgdownload.soe.ucsc.edu/hubs/UCSC_GI.assemblyHubList.txt";
        ArrayList<String> errors = new ArrayList<String>();
        boolean genomeListLoaded = HostedGenomes.loadGenomeList(genomesServerURL, "assembly", errors);
        if (!genomeListLoaded) {
            log.error("Error loading genome list from: " + genomesServerURL);
            errors.add("Error loading genome list from: " + genomesServerURL);
            if (!HostedGenomes.loadGenomeList(backupGenomesServerURL, "assembly", errors)) {
                errors.add("Error loading genome list from: " + backupGenomesServerURL);
            }
        }
        if (!HostedGenomes.loadGenomeList("https://hgdownload.soe.ucsc.edu/hubs/UCSC_GI.assemblyHubList.txt", "assembly", errors)) {
            log.error("Error connecting to UCSC Genark server URL: https://hgdownload.soe.ucsc.edu/hubs/UCSC_GI.assemblyHubList.txt");
            errors.add("Error connecting to UCSC Genark server: https://hgdownload.soe.ucsc.edu/hubs/UCSC_GI.assemblyHubList.txt");
        }
        if (!errors.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String error : errors) {
                sb.append(error).append("\n");
            }
            MessageUtils.showMessage(sb.toString());
        }
        return records;
    }

    private static boolean loadGenomeList(String url, String idColumn, List<String> errors) {
        try {
            String genomeListContent = HttpUtils.getInstance().getContentsAsString(new URL(url));
            List<String> genomeListLines = Arrays.asList(genomeListContent.split("\\r?\\n"));
            String[] headers = HostedGenomes.parseHeaders(genomeListLines);
            HostedGenomes.parseRecords(genomeListLines, headers, idColumn);
            return true;
        }
        catch (Exception e) {
            log.error("Error loading genome list from: " + url, e);
            errors.add("Error loading genome list from: " + url + "   (" + e.getMessage() + ")");
            return false;
        }
    }

    private static String[] parseHeaders(List<String> genomeListLines) {
        String[] tokens;
        String line;
        String[] headers = null;
        String lastHeaderLine = null;
        for (int i = 0; i < genomeListLines.size() && (line = genomeListLines.get(i).trim()).startsWith("#"); ++i) {
            lastHeaderLine = line;
        }
        headers = lastHeaderLine != null ? ((tokens = (String[])Arrays.stream(Globals.tabPattern.split(lastHeaderLine.substring(1))).map(h -> h.trim()).toArray(String[]::new)).length >= 3 ? tokens : legacyColumns) : legacyColumns;
        return headers;
    }

    private static void parseRecords(List<String> genomeListLines, String[] headers, String idColumn) {
        for (String line : genomeListLines) {
            if (line.startsWith("<Server-Side>") || line.startsWith("#")) continue;
            line = line.trim();
            String[] values = Globals.tabPattern.split(line.trim());
            HashMap<String, String> attributes = new HashMap<String, String>();
            for (int i = 0; i < headers.length; ++i) {
                attributes.put(headers[i], values[i]);
            }
            String id = (String)attributes.get(idColumn);
            String displayableName = (String)attributes.get("common name");
            String path = (String)attributes.get("url");
            records.add(new GenomeListItem(displayableName, path, id, attributes));
        }
    }

    static {
        hostedGenomesMap = null;
    }
}

