/*
 * Decompiled with CFR 0.152.
 */
package org.igv.feature.genome;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.igv.DirectoryManager;
import org.igv.feature.genome.load.GenomeConfig;
import org.igv.feature.genome.load.TrackConfig;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.ui.IGV;
import org.igv.ui.util.download.Downloader;
import org.igv.util.FileUtils;
import org.json.JSONObject;

public class GenomeDownloadUtils {
    private static Logger log = LogManager.getLogger(GenomeDownloadUtils.class);
    static Set<String> disallowedBuckets = new HashSet<String>(Arrays.asList("igv.org.genomes", "igv-genepattern-org", "igv.broadinstitute.org"));

    public static boolean isAnnotationsDownloadable(String path) {
        return path.endsWith(".json");
    }

    public static boolean isSequenceDownloadable(String genomePath) {
        if (genomePath != null && genomePath.endsWith(".json")) {
            try {
                String jsonString = FileUtils.getContents(genomePath);
                GenomeConfig genomeConfig = GenomeConfig.fromJson(jsonString);
                String sequenceURL = genomeConfig.twoBitURL;
                if (sequenceURL == null) {
                    sequenceURL = genomeConfig.fastaURL;
                }
                return GenomeDownloadUtils.isRemoteURL(sequenceURL);
            }
            catch (IOException e) {
                log.error("Error fetching genome json " + genomePath);
            }
        }
        return false;
    }

    public static File downloadGenome(GenomeConfig genomeConfig, boolean downloadSequence, boolean downloadAnnotations) throws IOException {
        GenomeConfig config = genomeConfig.copy();
        File genomeDirectory = DirectoryManager.getGenomeCacheDirectory();
        File dataDirectory = null;
        if (downloadSequence || downloadAnnotations) {
            dataDirectory = new File(genomeDirectory, config.id);
            if (dataDirectory.exists()) {
                if (!dataDirectory.isDirectory()) {
                    throw new RuntimeException("Error downloading genome. " + dataDirectory.getAbsolutePath() + " exists and is not a directory.");
                }
            } else if (!dataDirectory.mkdir()) {
                throw new RuntimeException("Error downloading genome.  Could not create directory: " + dataDirectory.getAbsolutePath());
            }
        }
        String relativeDataDirectory = config.id + "/";
        if (config.twoBitURL != null) {
            URL url = new URL(config.twoBitURL);
            File localFile = downloadSequence ? GenomeDownloadUtils.download(url, dataDirectory) : GenomeDownloadUtils.constructLocalFile(url, dataDirectory);
            if (localFile.exists()) {
                config.twoBitURL = relativeDataDirectory + localFile.getName();
                config.fastaURL = null;
                config.indexURL = null;
                config.gziIndexURL = null;
                config.twoBitBptURL = null;
            }
        } else if (config.fastaURL != null) {
            String[] fastaFields = new String[]{"fastaURL", "indexURL", "gziIndexURL", "compressedIndexURL"};
            GenomeDownloadUtils.downloadAndUpdateConfig(downloadSequence, fastaFields, config, dataDirectory, relativeDataDirectory, true);
        } else {
            throw new RuntimeException("Sequence for genome " + config.getName() + " is not downloadable.");
        }
        String[] annotationFields = new String[]{"chromAliasBbURL", "cytobandURL", "cytobandBbURL", "aliasURL", "chromSizesURL"};
        GenomeDownloadUtils.downloadAndUpdateConfig(downloadAnnotations, annotationFields, config, dataDirectory, relativeDataDirectory, false);
        List<TrackConfig> trackConfigs = config.getTrackConfigs();
        if (trackConfigs != null) {
            String[] trackFields = new String[]{"url", "indexURL", "trixURL"};
            for (TrackConfig trackConfig : trackConfigs) {
                GenomeDownloadUtils.downloadAndUpdateConfig(downloadAnnotations, trackFields, trackConfig, dataDirectory, relativeDataDirectory, false);
            }
        }
        return GenomeDownloadUtils.saveLocalGenome(config);
    }

    private static void downloadAndUpdateConfig(boolean downloadData, String[] fields, Object config, File dataDirectory, String relativeDataDirectory, boolean useLocalCache) {
        File localFile = null;
        for (String f : fields) {
            try {
                Field field = config.getClass().getDeclaredField(f);
                field.setAccessible(true);
                Object urlField = field.get(config);
                if (urlField == null) continue;
                URL url = new URL(urlField.toString());
                if (downloadData) {
                    localFile = GenomeDownloadUtils.download(url, dataDirectory);
                } else if (useLocalCache) {
                    localFile = GenomeDownloadUtils.constructLocalFile(url, dataDirectory);
                }
                if (localFile == null || !localFile.exists()) continue;
                field.set(config, relativeDataDirectory + localFile.getName());
            }
            catch (Exception e) {
                log.error(e);
            }
        }
    }

    public static File saveLocalGenome(GenomeConfig genomeConfig) throws IOException {
        String id = genomeConfig.id;
        String sanitizedId = id.replaceAll("[^a-zA-Z0-9-_]", "_");
        File localFile = new File(DirectoryManager.getGenomeCacheDirectory(), sanitizedId + ".json");
        log.info("Saving " + localFile.getAbsolutePath());
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(localFile));){
            JSONObject jsonObject = genomeConfig.toJSON();
            writer.write(jsonObject.toString(4));
        }
        return localFile;
    }

    public static File constructLocalFile(URL url, File directory) {
        String path = url.getPath();
        int idx = path.lastIndexOf(47);
        String filename = idx < 0 ? path : path.substring(idx + 1);
        return new File(directory, filename);
    }

    private static File download(URL url, File directory) throws MalformedURLException {
        File localFile = GenomeDownloadUtils.constructLocalFile(url, directory);
        boolean success = Downloader.download(url, localFile, IGV.getInstance().getMainFrame());
        if (!success) {
            throw new RuntimeException("Download canceled");
        }
        return localFile;
    }

    private static boolean isRemoteURL(String url) {
        return url.startsWith("http://") || url.startsWith("https://");
    }
}

