/*
 * Decompiled with CFR 0.152.
 */
package org.igv.feature.genome;

import java.io.IOException;
import java.util.List;
import org.igv.feature.IGVFeature;
import org.igv.feature.genome.ChromAlias;
import org.igv.feature.genome.ChromAliasSource;
import org.igv.feature.genome.Genome;
import org.igv.ucsc.bb.BBFile;

public class ChromAliasBB
extends ChromAliasSource {
    BBFile reader;

    public ChromAliasBB(String path, Genome genome) throws IOException {
        this.reader = new BBFile(path, genome);
    }

    void preload(List<String> chromosomeNames) {
        try {
            this.reader.preload();
            for (String chr : chromosomeNames) {
                this.search(chr);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getChromosomeAlias(String chr, String nameSet) {
        ChromAlias aliasRecord = (ChromAlias)this.aliasCache.get(chr);
        return aliasRecord != null && aliasRecord.containsKey(nameSet) ? aliasRecord.get(nameSet) : chr;
    }

    @Override
    public ChromAlias search(String alias) throws IOException {
        List<IGVFeature> results;
        if (!this.aliasCache.containsKey(alias) && (results = this.reader.search(alias)) != null) {
            for (IGVFeature f : results) {
                String chr = f.getChr();
                ChromAlias aliasRecord = new ChromAlias(chr);
                this.aliasCache.put(chr, aliasRecord);
                for (String key : f.getAttributeKeys()) {
                    String a = f.getAttribute(key);
                    aliasRecord.put(key, a);
                    this.aliasCache.put(a, aliasRecord);
                }
            }
        }
        return (ChromAlias)this.aliasCache.get(alias);
    }
}

