/*
 * Decompiled with CFR 0.152.
 */
package org.igv.feature.dsi;

import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.exception.CodecLineParsingException;
import htsjdk.tribble.readers.LineIterator;
import org.igv.Globals;
import org.igv.feature.dsi.DSIFeature;
import org.igv.feature.genome.Genome;
import org.igv.track.TrackProperties;
import org.igv.util.ParsingUtils;

public class DSICodec
extends AsciiFeatureCodec<DSIFeature> {
    private final Genome genome;
    private TrackProperties trackProperties;

    public DSICodec(Genome genome) {
        super(DSIFeature.class);
        this.genome = genome;
    }

    public DSIFeature decode(String line) {
        String[] tokens = Globals.tabPattern.split(line);
        if (tokens.length > 10) {
            String chr = this.genome == null ? tokens[0].trim() : this.genome.getCanonicalChrName(tokens[0].trim());
            DSIFeature feature = new DSIFeature();
            feature.chr = chr;
            feature.position = Integer.parseInt(tokens[1]) - 1;
            feature.base = tokens[2].charAt(0);
            feature.total = Integer.parseInt(tokens[3]);
            feature.meth = Integer.parseInt(tokens[4]);
            feature.unmeth = Integer.parseInt(tokens[5]);
            feature.type = tokens[6];
            feature.f = "NA".equals(tokens[7]) ? Integer.MIN_VALUE : Integer.parseInt(tokens[7]);
            feature.p = "NA".equals(tokens[7]) ? Integer.MIN_VALUE : Integer.parseInt(tokens[8]);
            feature.m = "NA".equals(tokens[7]) ? Integer.MIN_VALUE : Integer.parseInt(tokens[9]);
            feature.u = "NA".equals(tokens[7]) ? Integer.MIN_VALUE : Integer.parseInt(tokens[10]);
            return feature;
        }
        return null;
    }

    public boolean canDecode(String path) {
        return path.toLowerCase().endsWith(".dsi") || path.toLowerCase().endsWith(".dsi.gz");
    }

    public Object readActualHeader(LineIterator reader) {
        try {
            while (reader.hasNext()) {
                String line = reader.peek();
                if (line.startsWith("#")) {
                    reader.next();
                    continue;
                }
                if (!line.startsWith("#track") && !line.startsWith("##track")) break;
                this.trackProperties = new TrackProperties();
                ParsingUtils.parseTrackLine(line, this.trackProperties);
            }
            return this.trackProperties;
        }
        catch (Exception e) {
            throw new CodecLineParsingException("Error parsing header: " + e.getMessage(), (Throwable)e);
        }
    }
}

