/*
 * Decompiled with CFR 0.152.
 */
package org.igv.feature.cyto;

import java.awt.Rectangle;
import java.io.BufferedReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.igv.Globals;
import org.igv.feature.CytoBandFileParser;
import org.igv.feature.Cytoband;
import org.igv.feature.genome.Genome;
import org.igv.renderer.CytobandRenderer;
import org.igv.track.AbstractTrack;
import org.igv.track.RenderContext;
import org.igv.track.TrackClickEvent;
import org.igv.ui.panel.IGVPopupMenu;
import org.igv.ui.panel.ReferenceFrame;
import org.igv.util.ResourceLocator;

public class CytobandTrack
extends AbstractTrack {
    Map<String, List<Cytoband>> chrCytoMap;
    CytobandRenderer renderer;

    public CytobandTrack(ResourceLocator locator, BufferedReader reader, Genome genome) {
        super(locator);
        this.setHeight(30);
        this.renderer = new CytobandRenderer(Globals.isDarkMode());
        this.load(reader, genome);
    }

    protected void load(BufferedReader reader, Genome genome) {
        LinkedHashMap<String, List<Cytoband>> map = CytoBandFileParser.loadData(reader);
        this.chrCytoMap = new HashMap<String, List<Cytoband>>();
        for (Map.Entry entry : map.entrySet()) {
            String chr = genome == null ? (String)entry.getKey() : genome.getCanonicalChrName((String)entry.getKey());
            this.chrCytoMap.put(chr, (List)entry.getValue());
        }
    }

    @Override
    public boolean isReadyToPaint(ReferenceFrame frame) {
        return this.chrCytoMap != null;
    }

    @Override
    public void load(ReferenceFrame frame) {
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        List<Cytoband> cytobands = this.chrCytoMap.get(context.getChr());
        if (cytobands != null) {
            Rectangle trackRect = context.getVisibleRect().intersection(rect);
            this.renderer.drawTrack(cytobands, context.getGraphics(), trackRect, context.getReferenceFrame());
        }
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        return new IGVPopupMenu();
    }
}

